/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.node;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rex.RexOver;
import org.apache.impala.calcite.rel.node.ImpalaAggRel;
import org.apache.impala.calcite.rel.node.ImpalaAnalyticRel;
import org.apache.impala.calcite.rel.node.ImpalaFilterRel;
import org.apache.impala.calcite.rel.node.ImpalaHdfsScanRel;
import org.apache.impala.calcite.rel.node.ImpalaJoinRel;
import org.apache.impala.calcite.rel.node.ImpalaProjectRel;
import org.apache.impala.calcite.rel.node.ImpalaSortRel;
import org.apache.impala.calcite.rel.node.ImpalaUnionRel;
import org.apache.impala.calcite.rel.node.ImpalaValuesRel;

public class ConvertToImpalaRelRules {

    public static class ImpalaJoinRule
    extends RelOptRule {
        public ImpalaJoinRule() {
            super(ImpalaJoinRule.operand(LogicalJoin.class, (RelOptRuleOperandChildren)ImpalaJoinRule.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            LogicalJoin join = (LogicalJoin)call.rel(0);
            call.transformTo((RelNode)new ImpalaJoinRel((Join)join));
        }
    }

    public static class ImpalaValuesRule
    extends RelOptRule {
        public ImpalaValuesRule() {
            super(ImpalaValuesRule.operand(LogicalValues.class, (RelOptRuleOperandChildren)ImpalaValuesRule.none()));
        }

        public void onMatch(RelOptRuleCall call) {
            LogicalValues values = (LogicalValues)call.rel(0);
            call.transformTo((RelNode)new ImpalaValuesRel((Values)values));
        }
    }

    public static class ImpalaAggRule
    extends RelOptRule {
        public ImpalaAggRule() {
            super(ImpalaAggRule.operand(LogicalAggregate.class, (RelOptRuleOperandChildren)ImpalaAggRule.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            LogicalAggregate agg = (LogicalAggregate)call.rel(0);
            call.transformTo((RelNode)new ImpalaAggRel((Aggregate)agg));
        }
    }

    public static class ImpalaUnionRule
    extends RelOptRule {
        public ImpalaUnionRule() {
            super(ImpalaUnionRule.operand(LogicalUnion.class, (RelOptRuleOperandChildren)ImpalaUnionRule.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            LogicalUnion union = (LogicalUnion)call.rel(0);
            call.transformTo((RelNode)new ImpalaUnionRel((Union)union));
        }
    }

    public static class ImpalaSortRule
    extends RelOptRule {
        public ImpalaSortRule() {
            super(ImpalaSortRule.operand(LogicalSort.class, (RelOptRuleOperandChildren)ImpalaSortRule.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            LogicalSort sort = (LogicalSort)call.rel(0);
            call.transformTo((RelNode)new ImpalaSortRel((Sort)sort));
        }
    }

    public static class ImpalaScanRule
    extends RelOptRule {
        public ImpalaScanRule() {
            super(ImpalaScanRule.operand(LogicalTableScan.class, (RelOptRuleOperandChildren)ImpalaScanRule.none()));
        }

        public void onMatch(RelOptRuleCall call) {
            LogicalTableScan scan = (LogicalTableScan)call.rel(0);
            call.transformTo((RelNode)new ImpalaHdfsScanRel((TableScan)scan));
        }
    }

    public static class ImpalaFilterRule
    extends RelOptRule {
        public ImpalaFilterRule() {
            super(ImpalaFilterRule.operand(LogicalFilter.class, (RelOptRuleOperandChildren)ImpalaFilterRule.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            LogicalFilter filter = (LogicalFilter)call.rel(0);
            call.transformTo((RelNode)new ImpalaFilterRel((Filter)filter));
        }
    }

    public static class ImpalaProjectRule
    extends RelOptRule {
        public ImpalaProjectRule() {
            super(ImpalaProjectRule.operand(LogicalProject.class, (RelOptRuleOperandChildren)ImpalaProjectRule.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            List<RexOver> rexOvers = ImpalaAnalyticRel.gatherRexOver(project.getProjects());
            Project newProject = rexOvers.size() > 0 ? new ImpalaAnalyticRel((Project)project) : new ImpalaProjectRel((Project)project);
            call.transformTo((RelNode)newProject);
        }
    }
}

