/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.operators;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.util.ReflectiveSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.impala.calcite.operators.ImpalaAggOperator;
import org.apache.impala.calcite.operators.ImpalaCastFunction;
import org.apache.impala.calcite.operators.ImpalaCustomOperatorTable;
import org.apache.impala.calcite.operators.ImpalaOperator;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.catalog.Db;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaOperatorTable
extends ReflectiveSqlOperatorTable {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaOperatorTable.class.getName());
    public static Set<String> USE_IMPALA_OPERATOR = ImmutableSet.builder().add((Object)"year").add((Object)"month").add((Object)"week").add((Object)"day").add((Object)"hour").add((Object)"minute").add((Object)"second").add((Object)"millisecond").add((Object)"dayofmonth").add((Object)"dayofyear").add((Object)"weekofyear").add((Object)"corr").add((Object)"covar_pop").add((Object)"covar_samp").add((Object)"coalesce").add((Object)"lag").add((Object)"trim").add((Object)"extract").add((Object)"regr_count").add((Object)"localtime").add((Object)"translate").build();
    private static ImpalaOperatorTable INSTANCE;

    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        ImpalaCustomOperatorTable.instance().lookupOperatorOverloads(opName, category, syntax, operatorList, nameMatcher);
        if (operatorList.size() >= 1) {
            return;
        }
        String lowercaseOpName = opName.getSimple().toLowerCase();
        if (lowercaseOpName.equals("cast")) {
            operatorList.add((SqlOperator)ImpalaCastFunction.INSTANCE);
            return;
        }
        if (!USE_IMPALA_OPERATOR.contains(lowercaseOpName)) {
            SqlStdOperatorTable.instance().lookupOperatorOverloads(opName, category, syntax, operatorList, nameMatcher);
            Preconditions.checkState((operatorList.size() <= 1 ? 1 : 0) != 0);
            if (operatorList.size() == 1) {
                return;
            }
        }
        if (opName.names.size() > 1) {
            throw new RuntimeException("Cannot handle identifier with more than one name: " + opName);
        }
        List functions = BuiltinsDb.getInstance().getFunctions(lowercaseOpName);
        if (functions.size() == 0) {
            return;
        }
        Object impalaOp = functions.get(0) instanceof AggregateFunction ? new ImpalaAggOperator(opName.getSimple()) : new ImpalaOperator(opName.getSimple());
        operatorList.add((SqlOperator)impalaOp);
    }

    public static synchronized void create(Db db) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new ImpalaOperatorTable();
    }

    public static ImpalaOperatorTable getInstance() {
        return INSTANCE;
    }
}

