/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.operators;

import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.impala.calcite.operators.CommonOperatorFunctions;
import org.apache.impala.calcite.operators.ImpalaOperator;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.calcite.type.ImpalaTypeSystemImpl;

public class ImpalaDecodeFunction
extends ImpalaOperator {
    public static ImpalaDecodeFunction INSTANCE = new ImpalaDecodeFunction();

    private ImpalaDecodeFunction() {
        super("DECODE");
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        List<RelDataType> operandTypes = CommonOperatorFunctions.getOperandTypes(opBinding);
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl((RelDataTypeSystem)new ImpalaTypeSystemImpl()));
        RelDataTypeFactory factory = rexBuilder.getTypeFactory();
        ImpalaDecodeFunction.getCompatibleSearchOperand(operandTypes, factory);
        return ImpalaDecodeFunction.getCompatibleReturnType(operandTypes, factory);
    }

    public static RelDataType getCompatibleSearchOperand(List<RelDataType> operandTypes, RelDataTypeFactory factory) {
        RelDataType commonSearchOperand = operandTypes.get(0);
        int searchOperandsToCheck = operandTypes.size() / 2;
        for (int i = 1; i < operandTypes.size() - 1; i += 2) {
            if ((commonSearchOperand = ImpalaTypeConverter.getCompatibleType(commonSearchOperand, operandTypes.get(i), factory)) != null) continue;
            throw new IllegalArgumentException("Decode function has incompatible types with search argument and argument number " + i);
        }
        return commonSearchOperand;
    }

    public static RelDataType getCompatibleReturnType(List<RelDataType> operandTypes, RelDataTypeFactory factory) {
        RelDataType returnType = operandTypes.get(2);
        returnType = factory.createTypeWithNullability(returnType, true);
        for (int i = 4; i < operandTypes.size(); i += 2) {
            if ((returnType = ImpalaTypeConverter.getCompatibleType(returnType, operandTypes.get(i), factory)) != null) continue;
            throw new IllegalArgumentException("Decode function has incompatible return type (argument number) " + i);
        }
        if (operandTypes.size() % 2 == 0) {
            returnType = ImpalaTypeConverter.getCompatibleType(returnType, operandTypes.get(operandTypes.size() - 1), factory);
        }
        return returnType;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from((int)3);
    }
}

