/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.operators;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql2rel.ReflectiveConvertletTable;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.impala.calcite.operators.ImpalaCastFunction;
import org.apache.impala.calcite.operators.ImpalaConcatOrOperator;
import org.apache.impala.calcite.operators.ImpalaCustomOperatorTable;

public class ImpalaConvertletTable
extends ReflectiveConvertletTable {
    public static Set<String> IMPALA_OVERRIDE_CONVERTLETS = ImmutableSet.builder().add((Object)"||").build();
    public static final ImpalaConvertletTable INSTANCE = new ImpalaConvertletTable();

    public ImpalaConvertletTable() {
        this.addAlias((SqlOperator)ImpalaCustomOperatorTable.PERCENT_REMAINDER, (SqlOperator)SqlStdOperatorTable.MOD);
        this.registerOp((SqlOperator)ImpalaCastFunction.INSTANCE, this::convertExplicitCast);
        this.registerOp((SqlOperator)SqlStdOperatorTable.IS_DISTINCT_FROM, this::convertIsDistinctFrom);
        this.registerOp((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, this::convertIsNotDistinctFrom);
        this.registerOp((SqlOperator)ImpalaConcatOrOperator.INSTANCE, this::convertConcatOr);
    }

    public SqlRexConvertlet get(SqlCall call) {
        if (call.getOperator().equals((Object)ImpalaCustomOperatorTable.PERCENT_REMAINDER)) {
            return super.get(call);
        }
        if (call.getOperator().getKind().equals((Object)SqlKind.IS_DISTINCT_FROM) || call.getOperator().getKind().equals((Object)SqlKind.IS_NOT_DISTINCT_FROM)) {
            return super.get(call);
        }
        if (call.getOperator().getName().equals("EXPLICIT_CAST")) {
            return super.get(call);
        }
        if (IMPALA_OVERRIDE_CONVERTLETS.contains(call.getOperator().getName())) {
            return super.get(call);
        }
        return StandardConvertletTable.INSTANCE.get(call);
    }

    protected RexNode convertIsDistinctFrom(SqlRexContext cx, SqlCall call) {
        SqlNode expr1 = call.operand(0);
        SqlNode expr2 = call.operand(1);
        RexBuilder rexBuilder = cx.getRexBuilder();
        RelDataType returnType = cx.getValidator().getValidatedNodeTypeIfKnown((SqlNode)call);
        ArrayList operands = Lists.newArrayList((Object[])new RexNode[]{cx.convertExpression(expr1), cx.convertExpression(expr2)});
        return rexBuilder.makeCall(returnType, (SqlOperator)SqlStdOperatorTable.IS_DISTINCT_FROM, (List)operands);
    }

    protected RexNode convertIsNotDistinctFrom(SqlRexContext cx, SqlCall call) {
        SqlNode expr1 = call.operand(0);
        SqlNode expr2 = call.operand(1);
        RexBuilder rexBuilder = cx.getRexBuilder();
        RelDataType returnType = cx.getValidator().getValidatedNodeTypeIfKnown((SqlNode)call);
        ArrayList operands = Lists.newArrayList((Object[])new RexNode[]{cx.convertExpression(expr1), cx.convertExpression(expr2)});
        return rexBuilder.makeCall(returnType, (SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, (List)operands);
    }

    protected RexNode convertExplicitCast(SqlRexContext cx, SqlCall call) {
        SqlNode expr = call.operand(0);
        RexBuilder rexBuilder = cx.getRexBuilder();
        RelDataType returnType = cx.getValidator().getValidatedNodeTypeIfKnown((SqlNode)call);
        ArrayList operands = Lists.newArrayList((Object[])new RexNode[]{cx.convertExpression(expr)});
        return rexBuilder.makeCall(returnType, (SqlOperator)ImpalaCastFunction.INSTANCE, (List)operands);
    }

    protected RexNode convertConcatOr(SqlRexContext cx, SqlCall call) {
        SqlNode expr1 = call.operand(0);
        SqlNode expr2 = call.operand(1);
        RexBuilder rexBuilder = cx.getRexBuilder();
        RelDataType returnType = cx.getValidator().getValidatedNodeTypeIfKnown((SqlNode)call);
        ArrayList operands = Lists.newArrayList((Object[])new RexNode[]{cx.convertExpression(expr1), cx.convertExpression(expr2)});
        SqlBinaryOperator op = returnType.getSqlTypeName().equals((Object)SqlTypeName.BOOLEAN) ? SqlStdOperatorTable.OR : SqlStdOperatorTable.CONCAT;
        return rexBuilder.makeCall(returnType, (SqlOperator)op, (List)operands);
    }
}

