/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.operators;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.impala.calcite.operators.CommonOperatorFunctions;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.catalog.Type;

public class ImpalaConcatOrOperator
extends SqlBinaryOperator {
    public static ImpalaConcatOrOperator INSTANCE = new ImpalaConcatOrOperator();

    public ImpalaConcatOrOperator() {
        super("||", SqlKind.OTHER, 22, true, null, null, null);
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        List<RelDataType> operandTypes = CommonOperatorFunctions.getOperandTypes(opBinding);
        Preconditions.checkState((operandTypes.size() == 2 ? 1 : 0) != 0);
        if (this.isOrOperand(opBinding, operandTypes.get(0), 0) && this.isOrOperand(opBinding, operandTypes.get(1), 1)) {
            return ImpalaTypeConverter.getRelDataType((Type)Type.BOOLEAN);
        }
        return ImpalaTypeConverter.getRelDataType((Type)Type.STRING);
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of((int)2);
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return true;
    }

    private boolean isOrOperand(SqlOperatorBinding opBinding, RelDataType opType, int opNum) {
        return opType.getSqlTypeName() == SqlTypeName.BOOLEAN || opBinding.isOperandNull(opNum, false);
    }
}

