/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.operators;

import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.impala.calcite.operators.CommonOperatorFunctions;
import org.apache.impala.calcite.operators.ImpalaOperator;
import org.apache.impala.calcite.type.ImpalaTypeSystemImpl;

public class ImpalaCastFunction
extends ImpalaOperator {
    public static ImpalaCastFunction INSTANCE = new ImpalaCastFunction();

    public ImpalaCastFunction() {
        super("EXPLICIT_CAST");
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        List<RelDataType> operandTypes = CommonOperatorFunctions.getOperandTypes(opBinding);
        String castFunctionName = "castto" + this.getCastToName(operandTypes.get(1));
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl((RelDataTypeSystem)new ImpalaTypeSystemImpl()));
        RelDataTypeFactory factory = rexBuilder.getTypeFactory();
        List<RelDataType> castFromList = operandTypes.subList(0, 1);
        return CommonOperatorFunctions.isNullable(castFromList) ? factory.createTypeWithNullability(operandTypes.get(1), true) : operandTypes.get(1);
    }

    private String getCastToName(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case TINYINT: {
                return "tinyint";
            }
            case SMALLINT: {
                return "smallint";
            }
            case INTEGER: {
                return "int";
            }
            case BIGINT: {
                return "bigint";
            }
            case VARCHAR: {
                return "string";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case FLOAT: {
                return "float";
            }
            case REAL: 
            case DOUBLE: {
                return "double";
            }
            case DECIMAL: {
                return "decimal";
            }
            case CHAR: {
                return "char";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case DATE: {
                return "date";
            }
            case BINARY: {
                return "binary";
            }
        }
        throw new RuntimeException("Type " + type + "  not supported for casting.");
    }
}

