/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.operators;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;

public class ImpalaAdjustScaleFunction
extends SqlFunction {
    public ImpalaAdjustScaleFunction(String name) {
        super(name, null, SqlKind.OTHER_FUNCTION, null, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC_OPTIONAL_INTEGER, SqlFunctionCategory.NUMERIC);
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        if (opBinding.getOperandType(0).getSqlTypeName().equals((Object)SqlTypeName.DOUBLE) || opBinding.getOperandType(0).getSqlTypeName().equals((Object)SqlTypeName.FLOAT)) {
            return ImpalaTypeConverter.getRelDataType((Type)Type.DOUBLE);
        }
        ScalarType impalaType = (ScalarType)ImpalaTypeConverter.createImpalaType(opBinding.getOperandType(0));
        ScalarType decimalType = impalaType.getMinResolutionDecimal();
        int precision = this.getName().equals("ROUND") || this.getName().equals("DROUND") ? Math.min(decimalType.decimalPrecision() + 1, 38) : decimalType.decimalPrecision();
        Integer scale = opBinding.getOperandCount() > 1 ? (Integer)opBinding.getOperandLiteralValue(1, Integer.class) : Integer.valueOf(0);
        ScalarType newDecimalType = ScalarType.createDecimalType((int)precision, (int)scale);
        return ImpalaTypeConverter.createRelDataType((Type)newDecimalType);
    }
}

