/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.operators;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.impala.calcite.functions.FunctionResolver;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.calcite.type.ImpalaTypeSystemImpl;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.Type;

public class CommonOperatorFunctions {
    public static SqlOperandCountRange ANY_COUNT_RANGE = SqlOperandCountRanges.any();

    public static RelDataType inferReturnType(SqlOperatorBinding opBinding, String name) {
        List<RelDataType> operandTypes = CommonOperatorFunctions.getOperandTypes(opBinding);
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl((RelDataTypeSystem)new ImpalaTypeSystemImpl()));
        RelDataTypeFactory factory = rexBuilder.getTypeFactory();
        Function fn = CommonOperatorFunctions.getSupertypeFunction(name, operandTypes);
        if (fn == null) {
            throw new IllegalArgumentException("Cannot infer return type for " + name + "; operand types: " + operandTypes);
        }
        RelDataType returnType = fn.getReturnType().equals((Object)Type.DECIMAL) ? ImpalaTypeConverter.getCompatibleType(operandTypes, factory) : ImpalaTypeConverter.getRelDataType(fn.getReturnType());
        return CommonOperatorFunctions.isNullable(operandTypes) ? returnType : factory.createTypeWithNullability(returnType, true);
    }

    public static SqlOperandCountRange getOperandCountRange() {
        return ANY_COUNT_RANGE;
    }

    public static String getAllowedSignatures(String opNameToUse) {
        return "";
    }

    public static List<RelDataType> getOperandTypes(SqlOperatorBinding opBinding) {
        ArrayList<RelDataType> operandTypes = new ArrayList<RelDataType>(opBinding.getOperandCount());
        for (int i = 0; i < opBinding.getOperandCount(); ++i) {
            operandTypes.add(CommonOperatorFunctions.getOperandType(opBinding, i));
        }
        return operandTypes;
    }

    public static RelDataType getOperandType(SqlOperatorBinding opBinding, int operand) {
        if (opBinding instanceof Aggregate.AggCallBinding) {
            return opBinding.getOperandType(operand);
        }
        if (opBinding.isOperandNull(operand, false)) {
            return ImpalaTypeConverter.getRelDataType((Type)Type.NULL);
        }
        RelDataType opType = opBinding.getOperandType(operand);
        if (opType.getSqlTypeName().equals((Object)SqlTypeName.INTEGER) && opBinding.isOperandLiteral(operand, true)) {
            BigDecimal bd0 = (BigDecimal)opBinding.getOperandLiteralValue(operand, BigDecimal.class);
            return ImpalaTypeConverter.getLiteralDataType(bd0, opType);
        }
        return opType;
    }

    public static boolean isNullable(List<RelDataType> operandTypes) {
        return operandTypes.stream().anyMatch(rdt -> rdt.isNullable());
    }

    private static Function getSupertypeFunction(String name, List<RelDataType> operandTypes) {
        Function fn = FunctionResolver.getSupertypeFunction(name, operandTypes);
        if (fn != null) {
            return fn;
        }
        boolean hasChar = false;
        ArrayList<RelDataType> adjustedTypes = new ArrayList<RelDataType>();
        for (RelDataType opType : operandTypes) {
            if (opType.getSqlTypeName().equals((Object)SqlTypeName.CHAR)) {
                adjustedTypes.add(ImpalaTypeConverter.getRelDataType((Type)Type.STRING));
                hasChar = true;
                continue;
            }
            adjustedTypes.add(opType);
        }
        return hasChar ? FunctionResolver.getSupertypeFunction(name, adjustedTypes) : null;
    }
}

