/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimestampString;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.DateLiteral;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.calcite.functions.AnalyzedFunctionCallExpr;
import org.apache.impala.calcite.functions.AnalyzedNullLiteral;
import org.apache.impala.calcite.functions.FunctionResolver;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RexLiteralConverter {
    protected static final Logger LOG = LoggerFactory.getLogger((String)RexLiteralConverter.class.getName());

    public static Expr getExpr(RexLiteral rexLiteral) {
        if (SqlTypeName.INTERVAL_TYPES.contains(rexLiteral.getTypeName())) {
            return NumericLiteral.create((BigDecimal)new BigDecimal((Long)rexLiteral.getValueAs(Long.class)), (Type)Type.BIGINT);
        }
        switch (rexLiteral.getTypeName()) {
            case NULL: {
                Type type = ImpalaTypeConverter.createImpalaType(rexLiteral.getType());
                return new AnalyzedNullLiteral(type);
            }
            case BOOLEAN: {
                BoolLiteral boolExpr = new BoolLiteral(((Boolean)rexLiteral.getValueAs(Boolean.class)).booleanValue());
                return boolExpr;
            }
            case BIGINT: 
            case DECIMAL: 
            case DOUBLE: {
                NumericLiteral numericExpr = NumericLiteral.create((BigDecimal)((BigDecimal)rexLiteral.getValueAs(BigDecimal.class)), (Type)ImpalaTypeConverter.createImpalaType(rexLiteral.getType()));
                return numericExpr;
            }
            case CHAR: 
            case VARCHAR: {
                ScalarType charType = rexLiteral.getType().getSqlTypeName() == SqlTypeName.VARCHAR ? Type.STRING : ScalarType.createCharType((int)((String)rexLiteral.getValueAs(String.class)).length());
                StringLiteral charExpr = new StringLiteral((String)rexLiteral.getValueAs(String.class), (Type)charType, false);
                return charExpr;
            }
            case DATE: {
                DateString dateStringClass = (DateString)rexLiteral.getValueAs(DateString.class);
                String dateString = dateStringClass == null ? null : dateStringClass.toString();
                DateLiteral dateExpr = new DateLiteral(((Integer)rexLiteral.getValueAs(Integer.class)).intValue(), dateString);
                return dateExpr;
            }
            case TIMESTAMP: {
                return RexLiteralConverter.createCastTimestampExpr(rexLiteral);
            }
        }
        Preconditions.checkState((boolean)false, (Object)("Unsupported RexLiteral: " + rexLiteral.getTypeName()));
        return null;
    }

    private static Expr createCastTimestampExpr(RexLiteral rexLiteral) {
        ImmutableList typeNames = ImmutableList.of((Object)ImpalaTypeConverter.getRelDataType((Type)Type.STRING));
        String timestamp = ((TimestampString)rexLiteral.getValueAs(TimestampString.class)).toString();
        ArrayList argList = Lists.newArrayList((Object[])new Expr[]{new StringLiteral(timestamp, (Type)Type.STRING, false)});
        Function castFunc = FunctionResolver.getExactFunction("casttotimestamp", (List<RelDataType>)typeNames);
        return new AnalyzedFunctionCallExpr(castFunc, argList, (Type)Type.TIMESTAMP);
    }
}

