/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlPosixRegexOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ArithmeticExpr;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CaseWhenClause;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.TimestampArithmeticExpr;
import org.apache.impala.calcite.functions.AnalyzedBinaryCompExpr;
import org.apache.impala.calcite.functions.AnalyzedCaseExpr;
import org.apache.impala.calcite.functions.AnalyzedCastExpr;
import org.apache.impala.calcite.functions.AnalyzedFunctionCallExpr;
import org.apache.impala.calcite.functions.AnalyzedNullLiteral;
import org.apache.impala.calcite.functions.FunctionResolver;
import org.apache.impala.calcite.functions.IntervalExpr;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RexCallConverter {
    protected static final Logger LOG = LoggerFactory.getLogger((String)RexCallConverter.class.getName());
    public static Map<SqlKind, BinaryPredicate.Operator> BINARY_OP_MAP = ImmutableMap.builder().put((Object)SqlKind.EQUALS, (Object)BinaryPredicate.Operator.EQ).put((Object)SqlKind.NOT_EQUALS, (Object)BinaryPredicate.Operator.NE).put((Object)SqlKind.GREATER_THAN, (Object)BinaryPredicate.Operator.GT).put((Object)SqlKind.GREATER_THAN_OR_EQUAL, (Object)BinaryPredicate.Operator.GE).put((Object)SqlKind.LESS_THAN, (Object)BinaryPredicate.Operator.LT).put((Object)SqlKind.LESS_THAN_OR_EQUAL, (Object)BinaryPredicate.Operator.LE).put((Object)SqlKind.IS_DISTINCT_FROM, (Object)BinaryPredicate.Operator.DISTINCT_FROM).put((Object)SqlKind.IS_NOT_DISTINCT_FROM, (Object)BinaryPredicate.Operator.NOT_DISTINCT).build();

    public static Expr getExpr(RexCall rexCall, List<Expr> params, RexBuilder rexBuilder, Analyzer analyzer) throws ImpalaException {
        switch (rexCall.getOperator().getKind()) {
            case OR: 
            case AND: {
                return RexCallConverter.createCompoundExpr(rexCall, params);
            }
            case CAST: {
                return RexCallConverter.createCastExpr(rexCall, params, analyzer);
            }
        }
        if (rexCall.getOperator().getName().toLowerCase().equals("explicit_cast")) {
            return RexCallConverter.createCastExpr(rexCall, params, analyzer);
        }
        String funcName = rexCall.getOperator().getName().toLowerCase();
        Expr dateExpr = RexCallConverter.handleDateExprs(funcName, rexCall, params, rexBuilder);
        if (dateExpr != null) {
            return dateExpr;
        }
        Function fn = RexCallConverter.getFunction(rexCall);
        if (fn == null) {
            List argTypes = Lists.transform((List)rexCall.getOperands(), RexNode::getType);
            Preconditions.checkState((boolean)false, (Object)("Could not find function \"" + funcName + "\" in Impala with args " + argTypes + " and return type " + rexCall.getType()));
            return null;
        }
        if (fn.functionName().equals("or")) {
            return RexCallConverter.createCompoundExpr(rexCall, params);
        }
        Type impalaRetType = ImpalaTypeConverter.createImpalaType(fn.getReturnType(), rexCall.getType().getPrecision(), rexCall.getType().getScale());
        if (rexCall.isA((Collection)SqlKind.BINARY_COMPARISON)) {
            return RexCallConverter.createBinaryCompExpr(fn, params, rexCall.getOperator().getKind(), impalaRetType);
        }
        if (fn.functionName().equals("decode")) {
            return RexCallConverter.createDecodeExpr(fn, params, impalaRetType);
        }
        switch (rexCall.getOperator().getKind()) {
            case CASE: {
                return RexCallConverter.createCaseExpr(fn, params, impalaRetType);
            }
            case POSIX_REGEX_CASE_SENSITIVE: 
            case POSIX_REGEX_CASE_INSENSITIVE: {
                return RexCallConverter.createRegexExpr(fn, params, impalaRetType, rexCall);
            }
        }
        return new AnalyzedFunctionCallExpr(fn, params, impalaRetType);
    }

    public static Expr handleDateExprs(String funcName, RexCall rexCall, List<Expr> params, RexBuilder rexBuilder) {
        if (SqlTypeName.INTERVAL_TYPES.contains(rexCall.getType().getSqlTypeName())) {
            return new IntervalExpr(rexCall, params.get(0));
        }
        if (RexCallConverter.isTimestampArithExpr(params)) {
            return RexCallConverter.createTimestampExpr(rexCall, params);
        }
        return null;
    }

    private static Function getFunction(RexCall call) {
        List argTypes = Lists.transform((List)call.getOperands(), RexNode::getType);
        String name = call.getOperator().getName();
        return FunctionResolver.getExactFunction(name, call.getKind(), argTypes);
    }

    private static Expr createCompoundExpr(RexCall rexCall, List<Expr> params) {
        switch (rexCall.getOperator().getKind()) {
            case OR: {
                return CompoundPredicate.createDisjunctivePredicate(params);
            }
            case AND: {
                return CompoundPredicate.createConjunctivePredicate(params);
            }
        }
        Preconditions.checkState((boolean)false, (Object)("Unknown type: " + rexCall.getOperator().getKind()));
        return null;
    }

    private static Expr createCastExpr(RexCall call, List<Expr> params, Analyzer analyzer) throws ImpalaException {
        Type impalaRetType = ImpalaTypeConverter.createImpalaType(call.getType());
        if (params.get(0).getType() == Type.NULL) {
            return new AnalyzedNullLiteral(impalaRetType);
        }
        if (params.get(0).getType().equals((Object)impalaRetType)) {
            return params.get(0);
        }
        params.get(0).analyze(analyzer);
        return new AnalyzedCastExpr(impalaRetType, params.get(0));
    }

    private static Expr createDecodeExpr(Function fn, List<Expr> params, Type impalaRetType) throws ImpalaException {
        AnalyzedFunctionCallExpr decodeExpr = new AnalyzedFunctionCallExpr(fn, params, impalaRetType);
        return new AnalyzedCaseExpr(fn, impalaRetType, decodeExpr);
    }

    private static Expr createCaseExpr(Function fn, List<Expr> params, Type retType) {
        ArrayList<CaseWhenClause> caseWhenClauses = new ArrayList<CaseWhenClause>();
        Expr whenParam = null;
        for (Expr param : params) {
            if (whenParam == null) {
                whenParam = param;
                continue;
            }
            caseWhenClauses.add(new CaseWhenClause(whenParam, param));
            whenParam = null;
        }
        return new AnalyzedCaseExpr(fn, caseWhenClauses, whenParam, retType);
    }

    private static Expr createBinaryCompExpr(Function fn, List<Expr> params, SqlKind sqlKind, Type retType) {
        Preconditions.checkArgument((params.size() == 2 ? 1 : 0) != 0);
        BinaryPredicate.Operator op = BINARY_OP_MAP.get(sqlKind);
        Preconditions.checkNotNull((Object)op, (Object)("Unknown Calcite op: " + sqlKind));
        return new AnalyzedBinaryCompExpr(fn, op, params.get(0), params.get(1));
    }

    private static Expr createRegexExpr(Function fn, List<Expr> params, Type impalaRetType, RexCall rexCall) throws ImpalaException {
        SqlPosixRegexOperator op = (SqlPosixRegexOperator)rexCall.getOperator();
        AnalyzedFunctionCallExpr regexpExpr = new AnalyzedFunctionCallExpr(fn, params, impalaRetType);
        return op.isNegated() ? new CompoundPredicate(CompoundPredicate.Operator.NOT, (Expr)regexpExpr, null) : regexpExpr;
    }

    private static Expr createTimestampExpr(RexCall rexCall, List<Expr> params) {
        int timestampParamIndex = SqlTypeUtil.isDatetime((RelDataType)((RexNode)rexCall.getOperands().get(0)).getType()) ? 0 : 1;
        int intervalIndex = timestampParamIndex == 0 ? 1 : 0;
        IntervalExpr intervalExpr = (IntervalExpr)params.get(intervalIndex);
        ArithmeticExpr.Operator op = RexCallConverter.getImpalaOp(rexCall);
        return new TimestampArithmeticExpr(op, params.get(timestampParamIndex), intervalExpr.getLiteral(), intervalExpr.getTimeUnit(), intervalIndex == 0);
    }

    private static ArithmeticExpr.Operator getImpalaOp(RexCall rexCall) {
        if (rexCall.getOperator().getName().equals("DATE_ADD") || rexCall.getOperator().getKind().equals((Object)SqlKind.PLUS)) {
            return ArithmeticExpr.Operator.ADD;
        }
        if (rexCall.getOperator().getName().equals("DATE_SUB") || rexCall.getOperator().getKind().equals((Object)SqlKind.MINUS)) {
            return ArithmeticExpr.Operator.SUBTRACT;
        }
        throw new RuntimeException("Unknown Operator found in arith expr: " + rexCall.getOperator().getName());
    }

    public static boolean isTimestampArithExpr(List<Expr> params) {
        if (params.size() != 2) {
            return false;
        }
        return params.get(0) instanceof IntervalExpr || params.get(1) instanceof IntervalExpr;
    }
}

