/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.functions;

import com.google.common.base.Preconditions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TExprNode;

public class IntervalExpr
extends Expr {
    private final RexCall intervalExpr_;
    private final Expr literal_;
    private final String timeUnit_;

    public IntervalExpr(RexCall intervalExpr, Expr literalExpr) {
        Preconditions.checkState((boolean)intervalExpr.getOperator().getKind().equals((Object)SqlKind.TIMES));
        Preconditions.checkState((boolean)SqlTypeName.INTERVAL_TYPES.contains(((RexNode)intervalExpr.getOperands().get(1)).getType().getSqlTypeName()));
        this.intervalExpr_ = intervalExpr;
        this.literal_ = literalExpr;
        this.timeUnit_ = this.calcTimeIntervalUnit(intervalExpr);
    }

    public Expr getLiteral() {
        return this.literal_;
    }

    public String getTimeUnit() {
        return this.timeUnit_;
    }

    private String calcTimeIntervalUnit(RexCall call) {
        if (((RexNode)call.getOperands().get(1)).getType().toString().contains("WEEK")) {
            return "WEEK";
        }
        if (((RexNode)call.getOperands().get(1)).getType().toString().contains("MILLISECOND")) {
            return "MILLISECOND";
        }
        if (((RexNode)call.getOperands().get(1)).getType().toString().contains("MICROSECOND")) {
            return "MICROSECOND";
        }
        if (((RexNode)call.getOperands().get(1)).getType().toString().contains("NANOSECOND")) {
            return "NANOSECOND";
        }
        return ((RexNode)call.getOperands().get(1)).getType().getSqlTypeName().getStartUnit().toString();
    }

    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        throw new RuntimeException("not implemented");
    }

    protected float computeEvalCost() {
        throw new RuntimeException("not implemented");
    }

    protected String toSqlImpl(ToSqlOptions options) {
        throw new RuntimeException("not implemented");
    }

    protected void toThrift(TExprNode msg) {
        throw new RuntimeException("not implemented");
    }

    public Expr clone() {
        throw new RuntimeException("not implemented");
    }
}

