/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.functions;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplicitTypeChecker {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImplicitTypeChecker.class.getName());
    private static Set<Pair<SqlTypeName, SqlTypeName>> SUPPORTED_IMPLICIT_CASTS = ImmutableSet.builder().add((Object)Pair.of((Object)SqlTypeName.NULL, (Object)SqlTypeName.NULL)).add((Object)Pair.of((Object)SqlTypeName.NULL, (Object)SqlTypeName.BOOLEAN)).add((Object)Pair.of((Object)SqlTypeName.NULL, (Object)SqlTypeName.TINYINT)).add((Object)Pair.of((Object)SqlTypeName.NULL, (Object)SqlTypeName.SMALLINT)).add((Object)Pair.of((Object)SqlTypeName.NULL, (Object)SqlTypeName.INTEGER)).add((Object)Pair.of((Object)SqlTypeName.NULL, (Object)SqlTypeName.BIGINT)).add((Object)Pair.of((Object)SqlTypeName.NULL, (Object)SqlTypeName.FLOAT)).add((Object)Pair.of((Object)SqlTypeName.NULL, (Object)SqlTypeName.DOUBLE)).add((Object)Pair.of((Object)SqlTypeName.NULL, (Object)SqlTypeName.DECIMAL)).add((Object)Pair.of((Object)SqlTypeName.NULL, (Object)SqlTypeName.TIMESTAMP)).add((Object)Pair.of((Object)SqlTypeName.NULL, (Object)SqlTypeName.DATE)).add((Object)Pair.of((Object)SqlTypeName.NULL, (Object)SqlTypeName.CHAR)).add((Object)Pair.of((Object)SqlTypeName.NULL, (Object)SqlTypeName.VARCHAR)).add((Object)Pair.of((Object)SqlTypeName.NULL, (Object)SqlTypeName.BINARY)).add((Object)Pair.of((Object)SqlTypeName.BOOLEAN, (Object)SqlTypeName.BOOLEAN)).add((Object)Pair.of((Object)SqlTypeName.BOOLEAN, (Object)SqlTypeName.TINYINT)).add((Object)Pair.of((Object)SqlTypeName.BOOLEAN, (Object)SqlTypeName.SMALLINT)).add((Object)Pair.of((Object)SqlTypeName.BOOLEAN, (Object)SqlTypeName.INTEGER)).add((Object)Pair.of((Object)SqlTypeName.BOOLEAN, (Object)SqlTypeName.BIGINT)).add((Object)Pair.of((Object)SqlTypeName.BOOLEAN, (Object)SqlTypeName.FLOAT)).add((Object)Pair.of((Object)SqlTypeName.BOOLEAN, (Object)SqlTypeName.DOUBLE)).add((Object)Pair.of((Object)SqlTypeName.TINYINT, (Object)SqlTypeName.TINYINT)).add((Object)Pair.of((Object)SqlTypeName.TINYINT, (Object)SqlTypeName.SMALLINT)).add((Object)Pair.of((Object)SqlTypeName.TINYINT, (Object)SqlTypeName.INTEGER)).add((Object)Pair.of((Object)SqlTypeName.TINYINT, (Object)SqlTypeName.BIGINT)).add((Object)Pair.of((Object)SqlTypeName.TINYINT, (Object)SqlTypeName.FLOAT)).add((Object)Pair.of((Object)SqlTypeName.TINYINT, (Object)SqlTypeName.DOUBLE)).add((Object)Pair.of((Object)SqlTypeName.TINYINT, (Object)SqlTypeName.DECIMAL)).add((Object)Pair.of((Object)SqlTypeName.SMALLINT, (Object)SqlTypeName.SMALLINT)).add((Object)Pair.of((Object)SqlTypeName.SMALLINT, (Object)SqlTypeName.INTEGER)).add((Object)Pair.of((Object)SqlTypeName.SMALLINT, (Object)SqlTypeName.BIGINT)).add((Object)Pair.of((Object)SqlTypeName.SMALLINT, (Object)SqlTypeName.FLOAT)).add((Object)Pair.of((Object)SqlTypeName.SMALLINT, (Object)SqlTypeName.DOUBLE)).add((Object)Pair.of((Object)SqlTypeName.SMALLINT, (Object)SqlTypeName.DECIMAL)).add((Object)Pair.of((Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER)).add((Object)Pair.of((Object)SqlTypeName.INTEGER, (Object)SqlTypeName.BIGINT)).add((Object)Pair.of((Object)SqlTypeName.INTEGER, (Object)SqlTypeName.FLOAT)).add((Object)Pair.of((Object)SqlTypeName.INTEGER, (Object)SqlTypeName.DOUBLE)).add((Object)Pair.of((Object)SqlTypeName.INTEGER, (Object)SqlTypeName.DECIMAL)).add((Object)Pair.of((Object)SqlTypeName.BIGINT, (Object)SqlTypeName.BIGINT)).add((Object)Pair.of((Object)SqlTypeName.BIGINT, (Object)SqlTypeName.FLOAT)).add((Object)Pair.of((Object)SqlTypeName.BIGINT, (Object)SqlTypeName.DOUBLE)).add((Object)Pair.of((Object)SqlTypeName.BIGINT, (Object)SqlTypeName.DECIMAL)).add((Object)Pair.of((Object)SqlTypeName.FLOAT, (Object)SqlTypeName.FLOAT)).add((Object)Pair.of((Object)SqlTypeName.FLOAT, (Object)SqlTypeName.DOUBLE)).add((Object)Pair.of((Object)SqlTypeName.DOUBLE, (Object)SqlTypeName.DOUBLE)).add((Object)Pair.of((Object)SqlTypeName.TIMESTAMP, (Object)SqlTypeName.TIMESTAMP)).add((Object)Pair.of((Object)SqlTypeName.CHAR, (Object)SqlTypeName.CHAR)).add((Object)Pair.of((Object)SqlTypeName.CHAR, (Object)SqlTypeName.VARCHAR)).add((Object)Pair.of((Object)SqlTypeName.DATE, (Object)SqlTypeName.DATE)).add((Object)Pair.of((Object)SqlTypeName.DECIMAL, (Object)SqlTypeName.DECIMAL)).add((Object)Pair.of((Object)SqlTypeName.DECIMAL, (Object)SqlTypeName.FLOAT)).add((Object)Pair.of((Object)SqlTypeName.DECIMAL, (Object)SqlTypeName.DOUBLE)).add((Object)Pair.of((Object)SqlTypeName.DATE, (Object)SqlTypeName.TIMESTAMP)).add((Object)Pair.of((Object)SqlTypeName.BINARY, (Object)SqlTypeName.BINARY)).add((Object)Pair.of((Object)SqlTypeName.FLOAT, (Object)SqlTypeName.DECIMAL)).add((Object)Pair.of((Object)SqlTypeName.DOUBLE, (Object)SqlTypeName.DECIMAL)).build();

    public static boolean supportsImplicitCasting(RelDataType castFrom, RelDataType castTo) {
        if (SUPPORTED_IMPLICIT_CASTS.contains(Pair.of((Object)castFrom.getSqlTypeName(), (Object)castTo.getSqlTypeName()))) {
            return true;
        }
        return ImplicitTypeChecker.areCompatibleDataTypes(castFrom, castTo);
    }

    private static boolean areCompatibleDataTypes(RelDataType fromType, RelDataType toType) {
        if (fromType.getSqlTypeName().equals((Object)SqlTypeName.VARCHAR) && fromType.getPrecision() == Integer.MAX_VALUE) {
            if (toType.getPrecision() == Integer.MAX_VALUE) {
                return true;
            }
            switch (toType.getSqlTypeName()) {
                case DATE: 
                case TIMESTAMP: {
                    return true;
                }
            }
            return false;
        }
        if (!(fromType.getSqlTypeName().getFamily() != SqlTypeFamily.INTERVAL_DAY_TIME && fromType.getSqlTypeName().getFamily() != SqlTypeFamily.INTERVAL_YEAR_MONTH && toType.getSqlTypeName().getFamily() != SqlTypeFamily.INTERVAL_DAY_TIME && toType.getSqlTypeName().getFamily() != SqlTypeFamily.INTERVAL_YEAR_MONTH || fromType.getSqlTypeName().getFamily() != SqlTypeFamily.NUMERIC && toType.getSqlTypeName().getFamily() != SqlTypeFamily.NUMERIC)) {
            return true;
        }
        return fromType.getSqlTypeName() == toType.getSqlTypeName();
    }
}

