/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionResolver {
    protected static final Logger LOG = LoggerFactory.getLogger((String)FunctionResolver.class.getName());
    public static Map<SqlKind, String> CALCITE_KIND_TO_IMPALA_FUNC = ImmutableMap.builder().put((Object)SqlKind.EQUALS, (Object)"eq").put((Object)SqlKind.IS_FALSE, (Object)"isfalse").put((Object)SqlKind.IS_NOT_FALSE, (Object)"isnotfalse").put((Object)SqlKind.IS_NOT_NULL, (Object)"is_not_null_pred").put((Object)SqlKind.IS_NOT_TRUE, (Object)"isnottrue").put((Object)SqlKind.IS_NULL, (Object)"is_null_pred").put((Object)SqlKind.IS_TRUE, (Object)"istrue").put((Object)SqlKind.GREATER_THAN, (Object)"gt").put((Object)SqlKind.GREATER_THAN_OR_EQUAL, (Object)"ge").put((Object)SqlKind.LESS_THAN, (Object)"lt").put((Object)SqlKind.LESS_THAN_OR_EQUAL, (Object)"le").put((Object)SqlKind.NOT_EQUALS, (Object)"ne").put((Object)SqlKind.PLUS, (Object)"add").put((Object)SqlKind.MINUS, (Object)"subtract").put((Object)SqlKind.MINUS_PREFIX, (Object)"negative").put((Object)SqlKind.TIMES, (Object)"multiply").put((Object)SqlKind.DIVIDE, (Object)"divide").put((Object)SqlKind.SUM0, (Object)"sum_init_zero").put((Object)SqlKind.POSIX_REGEX_CASE_SENSITIVE, (Object)"regexp").put((Object)SqlKind.POSIX_REGEX_CASE_INSENSITIVE, (Object)"iregexp").put((Object)SqlKind.IS_NOT_DISTINCT_FROM, (Object)"notdistinct").put((Object)SqlKind.IS_DISTINCT_FROM, (Object)"distinctfrom").build();
    public static Map<String, String> CALCITE_NAME_TO_IMPALA_FUNC = ImmutableMap.builder().put((Object)"explicit_cast", (Object)"cast").put((Object)"||", (Object)"concat").build();
    public static Set<SqlKind> ARITHMETIC_TYPES = ImmutableSet.builder().add((Object)SqlKind.PLUS).add((Object)SqlKind.MINUS).add((Object)SqlKind.TIMES).add((Object)SqlKind.DIVIDE).add((Object)SqlKind.MOD).build();
    public static Set<String> SPECIAL_PROCESSING_FUNCTIONS = ImmutableSet.builder().add((Object)"grouping_id").add((Object)"count").build();

    public static Function getSupertypeFunction(RexCall call) {
        List argTypes = ARITHMETIC_TYPES.contains(call.getKind()) ? Lists.newArrayList((Object[])new RelDataType[]{call.getType(), call.getType()}) : Lists.transform((List)call.getOperands(), RexNode::getType);
        return FunctionResolver.getFunction(call.getOperator().getName(), call.getKind(), argTypes, false);
    }

    public static Function getSupertypeFunction(String name, SqlKind kind, List<RelDataType> argTypes) {
        return FunctionResolver.getFunction(name, kind, argTypes, false);
    }

    public static Function getExactFunction(String name, SqlKind kind, List<RelDataType> argTypes) {
        return FunctionResolver.getFunction(name, kind, argTypes, true);
    }

    public static Function getExactFunction(String name, List<RelDataType> argTypes) {
        return FunctionResolver.getFunction(name, argTypes, true);
    }

    public static Function getSupertypeFunction(String name, List<RelDataType> argTypes) {
        return FunctionResolver.getFunction(name, argTypes, false);
    }

    private static Function getFunction(String name, SqlKind kind, List<RelDataType> argTypes, boolean exactMatch) {
        return FunctionResolver.getFunction(FunctionResolver.getMappedName(name, kind, argTypes), argTypes, exactMatch);
    }

    private static String getMappedName(String name, SqlKind kind, List<RelDataType> argTypes) {
        String mappedName = CALCITE_KIND_TO_IMPALA_FUNC.get(kind);
        if (mappedName != null) {
            if (mappedName.equals("sum_init_zero") && !argTypes.get(0).getSqlTypeName().equals((Object)SqlTypeName.BIGINT)) {
                return "sum";
            }
            return mappedName;
        }
        String lowercaseName = name.toLowerCase();
        mappedName = CALCITE_NAME_TO_IMPALA_FUNC.get(lowercaseName);
        if (mappedName != null) {
            return mappedName;
        }
        return lowercaseName;
    }

    private static Function getFunction(String name, List<RelDataType> argTypes, boolean exactMatch) {
        String lowercaseName = name.toLowerCase();
        List<Type> impalaArgTypes = FunctionResolver.getArgTypes(lowercaseName, argTypes, exactMatch);
        return SPECIAL_PROCESSING_FUNCTIONS.contains(lowercaseName) ? FunctionResolver.getSpecialProcessingFunction(lowercaseName, impalaArgTypes, exactMatch) : FunctionResolver.getImpalaFunction(lowercaseName, impalaArgTypes, exactMatch);
    }

    private static Function getSpecialProcessingFunction(String lowercaseName, List<Type> impalaArgTypes, boolean exactMatch) {
        if (lowercaseName.equals("grouping_id")) {
            return AggregateFunction.createRewrittenBuiltin((Db)BuiltinsDb.getInstance(), (String)lowercaseName, impalaArgTypes, (Type)Type.BIGINT, (boolean)true, (boolean)false, (boolean)true);
        }
        if (lowercaseName.equals("count")) {
            if (impalaArgTypes.size() > 1) {
                impalaArgTypes = Lists.newArrayList((Object[])new Type[]{impalaArgTypes.get(0)});
            }
            return FunctionResolver.getImpalaFunction(lowercaseName, impalaArgTypes, exactMatch);
        }
        throw new RuntimeException("Special function not found: " + lowercaseName);
    }

    private static Function getImpalaFunction(String lowercaseName, List<Type> impalaArgTypes, boolean exactMatch) {
        Function searchDesc = new Function(new FunctionName("_impala_builtins", lowercaseName), impalaArgTypes, (Type)Type.INVALID, false);
        Function.CompareMode compareMode = exactMatch ? Function.CompareMode.IS_INDISTINGUISHABLE : Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF;
        Function fn = BuiltinsDb.getInstance().getFunction(searchDesc, compareMode);
        if (fn == null) {
            LOG.debug("Failed to find function " + lowercaseName);
            return null;
        }
        if (fn.isUnsupported()) {
            LOG.info("Function " + lowercaseName + " is not supported for given type.");
            return null;
        }
        return fn;
    }

    private static List<Type> getArgTypes(String name, List<RelDataType> argTypes, boolean exactMatch) {
        int caseOperandNum = FunctionResolver.getCaseOperandNum(name);
        if (caseOperandNum != -1) {
            return exactMatch ? Lists.newArrayList((Object[])new Type[]{ImpalaTypeConverter.createImpalaType(argTypes.get(caseOperandNum))}) : FunctionResolver.getCaseArgs(name, argTypes);
        }
        return ImpalaTypeConverter.getNormalizedImpalaTypes(argTypes);
    }

    private static int getCaseOperandNum(String name) {
        if (name.equals("case")) {
            return 1;
        }
        if (name.equals("decode")) {
            return 2;
        }
        return -1;
    }

    private static List<Type> getCaseArgs(String name, List<RelDataType> argTypes) {
        Preconditions.checkState((boolean)name.equals("case"));
        int numOperands = argTypes.size();
        ScalarType compatibleType = Type.NULL;
        for (int i = 0; i < numOperands; ++i) {
            if (FunctionResolver.shouldSkipOperandForCase(numOperands, i)) continue;
            Type impalaType = ImpalaTypeConverter.createImpalaType(argTypes.get(i));
            compatibleType = Type.getAssignmentCompatibleType((Type)compatibleType, (Type)impalaType, (TypeCompatibility)TypeCompatibility.DEFAULT);
        }
        return Lists.newArrayList((Object[])new Type[]{compatibleType});
    }

    public static boolean shouldSkipOperandForCase(int numOperands, int i) {
        return i % 2 == 0 && numOperands - 1 != i;
    }
}

