/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.functions;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.FunctionParams;
import org.apache.impala.calcite.functions.FunctionResolver;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;

public class AnalyzedFunctionCallExpr
extends FunctionCallExpr {
    private Function savedFunction_;

    public AnalyzedFunctionCallExpr(Function fn, List<Expr> params, Type retType) {
        super(fn.getFunctionName(), params);
        this.savedFunction_ = fn;
        this.type_ = retType;
    }

    public AnalyzedFunctionCallExpr(Function fn, FunctionParams funcParams, Type retType) {
        super(fn.getFunctionName(), funcParams);
        this.savedFunction_ = fn;
        this.type_ = retType;
    }

    public AnalyzedFunctionCallExpr(AnalyzedFunctionCallExpr other) {
        super((FunctionCallExpr)other);
        this.savedFunction_ = other.savedFunction_;
        this.type_ = other.type_;
    }

    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        this.getFnName().analyze(analyzer);
        this.fn_ = this.savedFunction_;
    }

    protected float computeEvalCost() {
        return 1.0f;
    }

    public Expr clone() {
        return new AnalyzedFunctionCallExpr(this);
    }

    public FunctionCallExpr cloneWithNewParams(FunctionParams params) {
        return new AnalyzedFunctionCallExpr(this.getFn(), params, this.type_);
    }

    public void resetAnalyticOffsetFn() throws ImpalaException {
        if (this.fn_ instanceof AggregateFunction) {
            String funcName;
            List<Type> operandTypes = Arrays.asList(this.collectChildReturnTypes());
            switch (funcName = this.getFnName().getFunction().toLowerCase()) {
                case "lag": 
                case "lead": {
                    Preconditions.checkArgument((operandTypes.size() == 3 && operandTypes.get(1).isIntegerType() ? 1 : 0) != 0);
                    if (operandTypes.get(1) != Type.BIGINT) {
                        operandTypes.set(1, (Type)Type.BIGINT);
                        this.uncheckedCastChild((Type)Type.BIGINT, 1);
                    }
                    if (operandTypes.get(2) == Type.NULL) {
                        Preconditions.checkArgument((operandTypes.get(0) != Type.NULL ? 1 : 0) != 0);
                        operandTypes.set(2, operandTypes.get(0));
                        this.uncheckedCastChild(operandTypes.get(0), 2);
                    }
                    this.savedFunction_ = this.fn_ = FunctionResolver.getExactFunction(this.getFnName().getFunction(), ImpalaTypeConverter.createRelDataTypes(operandTypes));
                    break;
                }
                default: {
                    throw new AnalysisException("Unsupported aggregate function.");
                }
            }
        }
    }
}

