/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.functions;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.AnalyticExpr;
import org.apache.impala.analysis.AnalyticWindow;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.OrderByElement;
import org.apache.impala.calcite.functions.AnalyzedFunctionCallExpr;
import org.apache.impala.calcite.functions.AnalyzedNullLiteral;
import org.apache.impala.catalog.Function;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;

public class AnalyzedAnalyticExpr
extends AnalyticExpr {
    public AnalyzedAnalyticExpr(FunctionCallExpr fnCall, List<Expr> partitionExprs, List<OrderByElement> orderByElements, AnalyticWindow window) throws ImpalaException {
        super(fnCall, partitionExprs, orderByElements, window);
        this.type_ = fnCall.getType();
    }

    public AnalyzedAnalyticExpr(AnalyzedAnalyticExpr other) {
        super((AnalyticExpr)other);
        this.type_ = other.type_;
    }

    public Expr clone() {
        return new AnalyzedAnalyticExpr(this);
    }

    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        FunctionCallExpr origFuncExpr = this.getFnCall();
        this.standardize(analyzer);
        if (this.getFnCall() != origFuncExpr) {
            this.setChildren();
            if (AnalyzedAnalyticExpr.isOffsetFn((Function)this.getFnCall().getFn())) {
                try {
                    Preconditions.checkArgument((boolean)(this.getFnCall() instanceof AnalyzedFunctionCallExpr));
                    ((AnalyzedFunctionCallExpr)this.getFnCall()).resetAnalyticOffsetFn();
                }
                catch (ImpalaException e) {
                    throw new AnalysisException((Throwable)e);
                }
            }
        }
    }

    protected Expr createNullLiteral() {
        return new AnalyzedNullLiteral(((Expr)this.getFnCall().getParams().exprs().get(0)).getType());
    }
}

