/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.type;

import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaTypeSystemImpl
extends RelDataTypeSystemImpl {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaTypeSystemImpl.class.getName());
    private static final int MAX_BINARY_PRECISION = Integer.MAX_VALUE;
    private static final int MAX_TIMESTAMP_PRECISION = 15;
    private static final int MAX_TIMESTAMP_WITH_LOCAL_TIME_ZONE_PRECISION = 15;
    private static final int DEFAULT_TINYINT_PRECISION = 3;
    private static final int DEFAULT_SMALLINT_PRECISION = 5;
    private static final int DEFAULT_INTEGER_PRECISION = 10;
    private static final int DEFAULT_BIGINT_PRECISION = 19;
    private static final int DEFAULT_FLOAT_PRECISION = 7;
    private static final int DEFAULT_DOUBLE_PRECISION = 15;

    public int getMaxScale(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return this.getMaxNumericScale();
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 9;
            }
        }
        return -1;
    }

    public int getDefaultPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case BINARY: 
            case VARBINARY: {
                return -1;
            }
            case CHAR: {
                return -1;
            }
            case VARCHAR: {
                return -1;
            }
            case DECIMAL: {
                return -1;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 2;
            }
        }
        return this.getMaxPrecision(typeName);
    }

    public int getMaxPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case BINARY: 
            case VARBINARY: {
                return Integer.MAX_VALUE;
            }
            case TIME: 
            case TIMESTAMP: {
                return 15;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return 15;
            }
            case CHAR: {
                return 255;
            }
            case VARCHAR: {
                return Integer.MAX_VALUE;
            }
            case DECIMAL: {
                return this.getMaxNumericPrecision();
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 10;
            }
            case TINYINT: {
                return 3;
            }
            case SMALLINT: {
                return 5;
            }
            case INTEGER: {
                return 10;
            }
            case BIGINT: {
                return 19;
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 15;
            }
        }
        return -1;
    }

    public int getMaxNumericScale() {
        return 38;
    }

    public int getMaxNumericPrecision() {
        return 38;
    }

    public boolean isSchemaCaseSensitive() {
        return false;
    }
}

