/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.type;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.impala.calcite.type.ImpalaTypeSystemImpl;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.thrift.TPrimitiveType;

public class ImpalaTypeConverter {
    private static Map<Type, RelDataType> impalaToCalciteMap;

    public static RelDataType createRelDataType(RelDataTypeFactory factory, Type impalaType) {
        if (impalaType == null) {
            return null;
        }
        TPrimitiveType primitiveType = impalaType.getPrimitiveType().toThrift();
        ScalarType scalarType = (ScalarType)impalaType;
        switch (primitiveType) {
            case DECIMAL: {
                RelDataType decimalDefinedRetType = factory.createSqlType(SqlTypeName.DECIMAL, scalarType.decimalPrecision(), scalarType.decimalScale());
                return factory.createTypeWithNullability(decimalDefinedRetType, true);
            }
            case VARCHAR: {
                RelDataType varcharType = factory.createSqlType(SqlTypeName.VARCHAR, scalarType.getLength());
                return factory.createTypeWithNullability(varcharType, true);
            }
            case CHAR: {
                RelDataType charType = factory.createSqlType(SqlTypeName.CHAR, scalarType.getLength());
                return factory.createTypeWithNullability(charType, true);
            }
        }
        Type normalizedImpalaType = ImpalaTypeConverter.getImpalaType(primitiveType);
        return impalaToCalciteMap.get(normalizedImpalaType);
    }

    public static RelDataType getRelDataType(Type impalaType) {
        if (impalaType == null) {
            return null;
        }
        TPrimitiveType primitiveType = impalaType.getPrimitiveType().toThrift();
        Type normalizedImpalaType = ImpalaTypeConverter.getImpalaType(primitiveType);
        return impalaToCalciteMap.get(normalizedImpalaType);
    }

    public static Type getImpalaType(TPrimitiveType argType) {
        switch (argType) {
            case CHAR: {
                return Type.CHAR;
            }
            case VARCHAR: {
                return Type.VARCHAR;
            }
            case DECIMAL: {
                return Type.DECIMAL;
            }
            case BOOLEAN: {
                return Type.BOOLEAN;
            }
            case TINYINT: {
                return Type.TINYINT;
            }
            case SMALLINT: {
                return Type.SMALLINT;
            }
            case INT: {
                return Type.INT;
            }
            case BIGINT: {
                return Type.BIGINT;
            }
            case FLOAT: {
                return Type.FLOAT;
            }
            case DOUBLE: {
                return Type.DOUBLE;
            }
            case TIMESTAMP: {
                return Type.TIMESTAMP;
            }
            case DATE: {
                return Type.DATE;
            }
            case STRING: {
                return Type.STRING;
            }
            case FIXED_UDA_INTERMEDIATE: {
                return Type.FIXED_UDA_INTERMEDIATE;
            }
            case NULL_TYPE: {
                return Type.NULL;
            }
            case BINARY: {
                return Type.BINARY;
            }
        }
        throw new RuntimeException("Unknown type " + argType);
    }

    public static Type createImpalaType(RelDataType relDataType) {
        if (relDataType.getSqlTypeName() == SqlTypeName.VARCHAR && (relDataType.getPrecision() == Integer.MAX_VALUE || relDataType.getPrecision() == -1)) {
            return Type.STRING;
        }
        Type impalaType = ImpalaTypeConverter.getType(relDataType.getSqlTypeName());
        return ImpalaTypeConverter.createImpalaType(impalaType, relDataType.getPrecision(), relDataType.getScale());
    }

    public static Type createImpalaType(Type impalaType, int precision, int scale) {
        TPrimitiveType primitiveType = impalaType.getPrimitiveType().toThrift();
        switch (primitiveType) {
            case CHAR: {
                return ScalarType.createCharType((int)precision);
            }
            case VARCHAR: {
                return precision == Integer.MAX_VALUE || precision == -1 ? Type.STRING : ScalarType.createVarcharType((int)precision);
            }
            case DECIMAL: {
                if (precision == -1) {
                    return Type.DECIMAL;
                }
                return ScalarType.createDecimalType((int)precision, (int)scale);
            }
            case FIXED_UDA_INTERMEDIATE: {
                return ScalarType.createFixedUdaIntermediateType((int)precision);
            }
        }
        return impalaType;
    }

    public static Type getType(SqlTypeName calciteTypeName) {
        switch (calciteTypeName) {
            case TINYINT: {
                return Type.TINYINT;
            }
            case SMALLINT: {
                return Type.SMALLINT;
            }
            case INTEGER: {
                return Type.INT;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_HOUR: 
            case INTERVAL_MINUTE: 
            case INTERVAL_SECOND: 
            case BIGINT: {
                return Type.BIGINT;
            }
            case VARCHAR: {
                return Type.VARCHAR;
            }
            case BOOLEAN: {
                return Type.BOOLEAN;
            }
            case REAL: 
            case FLOAT: {
                return Type.FLOAT;
            }
            case DOUBLE: {
                return Type.DOUBLE;
            }
            case DECIMAL: {
                return Type.DECIMAL;
            }
            case CHAR: {
                return Type.CHAR;
            }
            case TIMESTAMP: {
                return Type.TIMESTAMP;
            }
            case DATE: {
                return Type.DATE;
            }
            case NULL: {
                return Type.NULL;
            }
            case BINARY: {
                return Type.BINARY;
            }
        }
        throw new RuntimeException("Type " + calciteTypeName + "  not supported yet.");
    }

    public static List<Type> getNormalizedImpalaTypes(List<RelDataType> relDataTypes) {
        return Lists.transform(relDataTypes, ImpalaTypeConverter::getNormalizedImpalaType);
    }

    public static ScalarType getNormalizedImpalaType(RelDataType relDataType) {
        SqlTypeName sqlTypeName = relDataType.getSqlTypeName();
        if (SqlTypeName.INTERVAL_TYPES.contains(sqlTypeName)) {
            return Type.BIGINT;
        }
        switch (sqlTypeName) {
            case VARCHAR: {
                return relDataType.getPrecision() == Integer.MAX_VALUE ? Type.STRING : Type.VARCHAR;
            }
            case CHAR: {
                return Type.CHAR;
            }
            case DECIMAL: {
                return Type.DECIMAL;
            }
            case BOOLEAN: {
                return Type.BOOLEAN;
            }
            case TINYINT: {
                return Type.TINYINT;
            }
            case SMALLINT: {
                return Type.SMALLINT;
            }
            case INTEGER: {
                return Type.INT;
            }
            case BIGINT: {
                return Type.BIGINT;
            }
            case REAL: 
            case FLOAT: {
                return Type.FLOAT;
            }
            case DOUBLE: {
                return Type.DOUBLE;
            }
            case TIMESTAMP: {
                return Type.TIMESTAMP;
            }
            case DATE: {
                return Type.DATE;
            }
            case BINARY: {
                return Type.BINARY;
            }
            case SYMBOL: {
                return null;
            }
            case NULL: {
                return Type.NULL;
            }
        }
        throw new RuntimeException("Unknown SqlTypeName " + sqlTypeName + " to convert to Impala.");
    }

    public static List<RelDataType> createRelDataTypes(List<Type> impalaTypes) {
        ArrayList result = Lists.newArrayList();
        for (Type t : impalaTypes) {
            result.add(ImpalaTypeConverter.createRelDataType(t));
        }
        return result;
    }

    public static RelDataType createRelDataType(Type impalaType) {
        if (impalaType == null) {
            return null;
        }
        TPrimitiveType primitiveType = impalaType.getPrimitiveType().toThrift();
        if (primitiveType == TPrimitiveType.DECIMAL) {
            ScalarType scalarType = (ScalarType)impalaType;
            RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl((RelDataTypeSystem)new ImpalaTypeSystemImpl()));
            RelDataTypeFactory factory = rexBuilder.getTypeFactory();
            RelDataType decimalDefinedRetType = factory.createSqlType(SqlTypeName.DECIMAL, scalarType.decimalPrecision(), scalarType.decimalScale());
            return factory.createTypeWithNullability(decimalDefinedRetType, true);
        }
        Type normalizedImpalaType = ImpalaTypeConverter.getImpalaType(primitiveType);
        return impalaToCalciteMap.get(normalizedImpalaType);
    }

    static {
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl((RelDataTypeSystem)new ImpalaTypeSystemImpl()));
        RelDataTypeFactory factory = rexBuilder.getTypeFactory();
        HashMap<ScalarType, RelDataType> map = new HashMap<ScalarType, RelDataType>();
        map.put(Type.BOOLEAN, factory.createSqlType(SqlTypeName.BOOLEAN));
        map.put(Type.TINYINT, factory.createSqlType(SqlTypeName.TINYINT));
        map.put(Type.SMALLINT, factory.createSqlType(SqlTypeName.SMALLINT));
        map.put(Type.INT, factory.createSqlType(SqlTypeName.INTEGER));
        map.put(Type.BIGINT, factory.createSqlType(SqlTypeName.BIGINT));
        map.put(Type.FLOAT, factory.createSqlType(SqlTypeName.FLOAT));
        map.put(Type.DOUBLE, factory.createSqlType(SqlTypeName.DOUBLE));
        map.put(Type.TIMESTAMP, factory.createSqlType(SqlTypeName.TIMESTAMP));
        map.put(Type.DATE, factory.createSqlType(SqlTypeName.DATE));
        map.put(Type.DECIMAL, factory.createSqlType(SqlTypeName.DECIMAL));
        map.put(Type.BINARY, factory.createSqlType(SqlTypeName.BINARY));
        map.put(Type.CHAR, factory.createSqlType(SqlTypeName.CHAR, 1));
        map.put(Type.VARCHAR, factory.createSqlType(SqlTypeName.VARCHAR, 1));
        map.put(Type.STRING, factory.createSqlType(SqlTypeName.VARCHAR, Integer.MAX_VALUE));
        map.put(Type.NULL, factory.createSqlType(SqlTypeName.NULL));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Type t : map.keySet()) {
            RelDataType r = (RelDataType)map.get(t);
            builder.put((Object)t, (Object)factory.createTypeWithNullability(r, true));
        }
        impalaToCalciteMap = builder.build();
    }
}

