/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.service.CalciteJniFrontend;
import org.apache.impala.calcite.service.CalciteMetadataHandler;
import org.apache.impala.calcite.service.CalcitePhysPlanCreator;
import org.apache.impala.calcite.service.CompilerStep;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.DataPartition;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.DistributedPlanner;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.planner.NestedLoopJoinNode;
import org.apache.impala.planner.ParallelPlanner;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanRootSink;
import org.apache.impala.planner.Planner;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.RuntimeFilterGenerator;
import org.apache.impala.planner.SingleNodePlanner;
import org.apache.impala.planner.SingularRowSrcNode;
import org.apache.impala.planner.SubplanNode;
import org.apache.impala.service.Frontend;
import org.apache.impala.service.FrontendProfile;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TExecRequest;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPlanExecInfo;
import org.apache.impala.thrift.TPlanFragment;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryExecRequest;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.thrift.TRuntimeFilterMode;
import org.apache.impala.thrift.TRuntimeProfileNode;
import org.apache.impala.thrift.TStmtType;
import org.apache.impala.util.EventSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecRequestCreator
implements CompilerStep {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ExecRequestCreator.class.getName());
    private final CalcitePhysPlanCreator physPlanCreator;
    private final CalciteJniFrontend.QueryContext queryCtx;
    private final CalciteMetadataHandler mdHandler;

    public ExecRequestCreator(CalcitePhysPlanCreator physPlanCreator, CalciteJniFrontend.QueryContext queryCtx, CalciteMetadataHandler mdHandler) {
        this.physPlanCreator = physPlanCreator;
        this.queryCtx = queryCtx;
        this.mdHandler = mdHandler;
    }

    public TExecRequest create(NodeWithExprs nodeWithExprs) throws ImpalaException {
        TExecRequest request = this.createExecRequest(nodeWithExprs.planNode_, this.queryCtx.getTQueryCtx(), this.physPlanCreator.getPlannerContext(), this.physPlanCreator.getAnalyzer(), nodeWithExprs.outputExprs_, this.mdHandler.getStmtTableCache().tables.values());
        return request;
    }

    private TExecRequest createExecRequest(PlanNode planNodeRoot, TQueryCtx queryCtx, PlannerContext plannerContext, Analyzer analyzer, List<Expr> outputExprs, Collection<FeTable> tables) throws ImpalaException {
        List<PlanFragment> fragments = this.createPlans(planNodeRoot, analyzer, plannerContext, outputExprs);
        PlanFragment planFragmentRoot = fragments.get(0);
        TQueryExecRequest queryExecRequest = new TQueryExecRequest();
        TExecRequest result = this.createExecRequest(queryCtx, planFragmentRoot, queryExecRequest);
        queryExecRequest.setHost_list(this.getHostLocations(tables));
        queryExecRequest.setCores_required(-1);
        Planner.computeResourceReqs(fragments, (TQueryCtx)queryCtx, (TQueryExecRequest)queryExecRequest, (PlannerContext)plannerContext, (boolean)true);
        int idx = 0;
        for (PlanFragment planRoot : fragments) {
            TPlanExecInfo tPlanExecInfo = Frontend.createPlanExecInfo((PlanFragment)planRoot, (TQueryCtx)queryCtx);
            queryExecRequest.addToPlan_exec_info(tPlanExecInfo);
            for (TPlanFragment fragment : tPlanExecInfo.fragments) {
                fragment.setIdx(idx++);
            }
        }
        queryExecRequest.setQuery_ctx(queryCtx);
        List allFragments = planFragmentRoot.getNodesPreOrder();
        TExplainLevel explainLevel = TExplainLevel.EXTENDED;
        String explainString = this.getExplainString(allFragments, explainLevel, plannerContext);
        queryExecRequest.setQuery_plan(explainString);
        queryCtx.setDesc_tbl_serialized(plannerContext.getRootAnalyzer().getDescTbl().toSerializedThrift());
        plannerContext.getTimeline().markEvent("Execution request created");
        EventSequence eventSequence = plannerContext.getTimeline();
        result.setTimeline(eventSequence.toThrift());
        this.queryCtx.getFrontend();
        TRuntimeProfileNode calciteProfile = Frontend.createTRuntimeProfileNode((String)"PlannerInfo");
        this.queryCtx.getFrontend();
        Frontend.addPlannerToProfile((String)"CalcitePlanner");
        result.setProfile(FrontendProfile.getCurrent().emitAsThrift());
        result.setProfile_children(FrontendProfile.getCurrent().emitChildrenAsThrift());
        return result;
    }

    List<PlanFragment> createPlans(PlanNode planNodeRoot, Analyzer analyzer, PlannerContext ctx, List<Expr> outputExprs) throws ImpalaException {
        ArrayList<PlanFragment> rootFragments;
        analyzer.computeValueTransferGraph();
        Planner.checkForSmallQueryOptimization((PlanNode)planNodeRoot, (PlannerContext)ctx);
        ExecRequestCreator.invertJoins(planNodeRoot, ctx.isSingleNodeExec(), ctx.getRootAnalyzer());
        SingleNodePlanner.validatePlan((PlannerContext)ctx, (PlanNode)planNodeRoot);
        List<PlanFragment> fragments = this.createPlanFragments(planNodeRoot, ctx, analyzer, outputExprs);
        PlanFragment planFragmentRoot = fragments.get(0);
        if (Planner.useParallelPlan((PlannerContext)ctx)) {
            ParallelPlanner parallelPlanner = new ParallelPlanner(ctx);
            rootFragments = parallelPlanner.createPlans(planFragmentRoot);
            ctx.getTimeline().markEvent("Parallel plans created");
        } else {
            rootFragments = new ArrayList<PlanFragment>(Arrays.asList(planFragmentRoot));
        }
        return rootFragments;
    }

    private List<PlanFragment> createPlanFragments(PlanNode planNodeRoot, PlannerContext ctx, Analyzer analyzer, List<Expr> outputExprs) throws ImpalaException {
        ArrayList fragments;
        DistributedPlanner distributedPlanner = new DistributedPlanner(ctx);
        if (ctx.isSingleNodeExec()) {
            fragments = Lists.newArrayList((Object[])new PlanFragment[]{new PlanFragment(ctx.getNextFragmentId(), planNodeRoot, DataPartition.UNPARTITIONED)});
        } else {
            fragments = new ArrayList();
            boolean isPartitioned = false;
            distributedPlanner.createPlanFragments(planNodeRoot, isPartitioned, fragments);
        }
        PlanFragment rootFragment = (PlanFragment)fragments.get(fragments.size() - 1);
        if (ctx.getQueryOptions().getRuntime_filter_mode() != TRuntimeFilterMode.OFF) {
            RuntimeFilterGenerator.generateRuntimeFilters((PlannerContext)ctx, (PlanNode)rootFragment.getPlanRoot());
            ctx.getTimeline().markEvent("Runtime filters computed");
        }
        rootFragment.verifyTree();
        List<Expr> resultExprs = outputExprs;
        rootFragment.setSink((DataSink)new PlanRootSink(resultExprs));
        Planner.checkForDisableCodegen((PlanNode)rootFragment.getPlanRoot(), (PlannerContext)ctx);
        for (PlanFragment fragment : fragments) {
            fragment.finalizeExchanges(analyzer);
        }
        Collections.reverse(fragments);
        ctx.getTimeline().markEvent("Distributed plan created");
        return fragments;
    }

    private TExecRequest createExecRequest(TQueryCtx queryCtx, PlanFragment planFragmentRoot, TQueryExecRequest queryExecRequest) {
        TExecRequest result = new TExecRequest();
        result.setQuery_options(queryCtx.getClient_request().getQuery_options());
        result.setAccess_events(new ArrayList());
        result.setAnalysis_warnings(new ArrayList());
        result.setUser_has_profile_access(true);
        result.setQuery_exec_request(queryExecRequest);
        result.setStmt_type(TStmtType.QUERY);
        result.getQuery_exec_request().setStmt_type(TStmtType.QUERY);
        Preconditions.checkState((boolean)planFragmentRoot.hasSink());
        ArrayList<Expr> outputExprs = new ArrayList<Expr>();
        planFragmentRoot.getSink().collectExprs(outputExprs);
        result.setResult_set_metadata(this.createQueryResultSetMetadata(outputExprs));
        return result;
    }

    private String getExplainString(List<PlanFragment> fragments, TExplainLevel explainLevel, PlannerContext ctx) {
        if (explainLevel.ordinal() < TExplainLevel.VERBOSE.ordinal()) {
            return fragments.get(0).getExplainString(ctx.getQueryOptions(), explainLevel);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fragments.size(); ++i) {
            PlanFragment fragment = fragments.get(i);
            sb.append(fragment.getExplainString(ctx.getQueryOptions(), explainLevel));
            if (i >= fragments.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private TResultSetMetadata createQueryResultSetMetadata(List<Expr> outputExprs) {
        TResultSetMetadata metadata = new TResultSetMetadata();
        int colCnt = outputExprs.size();
        for (int i = 0; i < colCnt; ++i) {
            TColumn colDesc = new TColumn(outputExprs.get(i).toString(), outputExprs.get(i).getType().toThrift());
            metadata.addToColumns(colDesc);
        }
        return metadata;
    }

    private List<TNetworkAddress> getHostLocations(Collection<FeTable> tables) {
        HashSet hostLocations = new HashSet();
        for (FeTable table : tables) {
            if (!(table instanceof HdfsTable)) continue;
            hostLocations.addAll(((HdfsTable)table).getHostIndex().getList());
        }
        return new ArrayList<TNetworkAddress>(hostLocations);
    }

    private static boolean invertJoins(PlanNode root, boolean isLocalPlan, Analyzer analyzer) {
        boolean inverted = false;
        if (root instanceof SubplanNode) {
            inverted |= ExecRequestCreator.invertJoins((PlanNode)root.getChild(0), isLocalPlan, analyzer);
            inverted |= ExecRequestCreator.invertJoins((PlanNode)root.getChild(1), true, analyzer);
        } else {
            for (PlanNode child : root.getChildren()) {
                inverted |= ExecRequestCreator.invertJoins(child, isLocalPlan, analyzer);
            }
        }
        if (root instanceof JoinNode) {
            JoinNode joinNode = (JoinNode)root;
            JoinOperator joinOp = joinNode.getJoinOp();
            if (!joinNode.isInvertible(isLocalPlan)) {
                if (inverted) {
                    root.computeTupleIds();
                    root.computeStats(analyzer);
                }
                return inverted;
            }
            if (joinNode.getChild(0) instanceof SingularRowSrcNode) {
                joinNode.invertJoin();
                inverted = true;
            } else if (!isLocalPlan && joinNode instanceof NestedLoopJoinNode && (joinOp.isRightSemiJoin() || joinOp.isRightOuterJoin())) {
                joinNode.invertJoin();
                inverted = true;
            } else if (Planner.isInvertedJoinCheaper((JoinNode)joinNode, (boolean)isLocalPlan)) {
                joinNode.invertJoin();
                inverted = true;
            }
            joinNode.recomputeNodes();
        }
        if (inverted) {
            root.computeTupleIds();
            root.computeStats(analyzer);
        }
        return inverted;
    }

    @Override
    public void logDebug(Object resultObject) {
        if (!(resultObject instanceof TExecRequest)) {
            LOG.debug("Finished create exec request step, but unknown result: " + resultObject);
        }
        LOG.debug("Exec request: " + resultObject);
    }
}

