/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.impala.calcite.operators.ImpalaOperatorTable;
import org.apache.impala.calcite.service.CalciteJniFrontend;
import org.apache.impala.calcite.service.CalciteMetadataHandler;
import org.apache.impala.calcite.service.CompilerStep;
import org.apache.impala.calcite.type.ImpalaTypeSystemImpl;
import org.apache.impala.calcite.validate.ImpalaConformance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteValidator
implements CompilerStep {
    protected static final Logger LOG = LoggerFactory.getLogger((String)CalciteValidator.class.getName());
    private final CalciteMetadataHandler mdHandler;
    private final CalciteJniFrontend.QueryContext queryCtx;
    private final RelDataTypeFactory typeFactory;
    private final CalciteCatalogReader catalogReader;
    private final SqlValidator sqlValidator;

    public CalciteValidator(CalciteMetadataHandler mdHandler, CalciteJniFrontend.QueryContext queryCtx) {
        this.mdHandler = mdHandler;
        this.queryCtx = queryCtx;
        this.typeFactory = new JavaTypeFactoryImpl((RelDataTypeSystem)new ImpalaTypeSystemImpl());
        this.catalogReader = mdHandler.getCalciteCatalogReader();
        this.sqlValidator = SqlValidatorUtil.newValidator((SqlOperatorTable)ImpalaOperatorTable.getInstance(), (SqlValidatorCatalogReader)this.catalogReader, (RelDataTypeFactory)this.typeFactory, (SqlValidator.Config)SqlValidator.Config.DEFAULT.withConformance(ImpalaConformance.INSTANCE));
    }

    public SqlNode validate(SqlNode parsedNode) {
        SqlNode node = this.sqlValidator.validate(parsedNode);
        return node;
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public SqlValidator getSqlValidator() {
        return this.sqlValidator;
    }

    public CalciteCatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    @Override
    public void logDebug(Object resultObject) {
        if (!(resultObject instanceof SqlNode)) {
            LOG.debug("Finished validator step, but unknown result: " + resultObject);
            return;
        }
        LOG.debug("Validated node: " + resultObject);
    }
}

