/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.impala.calcite.service.CalciteValidator;
import org.apache.impala.calcite.service.CompilerStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteRelNodeConverter
implements CompilerStep {
    protected static final Logger LOG = LoggerFactory.getLogger((String)CalciteRelNodeConverter.class.getName());
    private static final RelOptTable.ViewExpander NOOP_EXPANDER = (type, query, schema, path) -> null;
    private final CalciteValidator validator_;
    private final RelOptCluster cluster_;
    private final RelOptPlanner planner_;

    public CalciteRelNodeConverter(CalciteValidator validator) {
        this.validator_ = validator;
        this.planner_ = new VolcanoPlanner();
        this.planner_.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        this.cluster_ = RelOptCluster.create((RelOptPlanner)this.planner_, (RexBuilder)new RexBuilder(this.validator_.getTypeFactory()));
    }

    public RelNode convert(SqlNode validatedNode) {
        SqlToRelConverter relConverter = new SqlToRelConverter(NOOP_EXPANDER, this.validator_.getSqlValidator(), (Prepare.CatalogReader)this.validator_.getCatalogReader(), this.cluster_, (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, SqlToRelConverter.config());
        RelRoot root = relConverter.convertQuery(validatedNode, false, true);
        RelNode relNode = root.project();
        this.logDebug(relNode);
        return relNode;
    }

    public RelOptCluster getCluster() {
        return this.cluster_;
    }

    public CalciteValidator getValidator() {
        return this.validator_;
    }

    @Override
    public void logDebug(Object resultObject) {
        if (!(resultObject instanceof RelNode)) {
            LOG.debug("RelNodeConverter produced an unknown output: " + resultObject);
            return;
        }
        LOG.info(RelOptUtil.dumpPlan((String)"[Logical plan]", (RelNode)((RelNode)resultObject), (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.NON_COST_ATTRIBUTES));
    }
}

