/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import org.apache.impala.analysis.Analyzer;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.rel.node.ParentPlanRelContext;
import org.apache.impala.calcite.service.CalciteJniFrontend;
import org.apache.impala.calcite.service.CalciteMetadataHandler;
import org.apache.impala.calcite.service.CompilerStep;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.util.AuthorizationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalcitePhysPlanCreator
implements CompilerStep {
    protected static final Logger LOG = LoggerFactory.getLogger((String)CalcitePhysPlanCreator.class.getName());
    private final CalciteJniFrontend.QueryContext queryCtx_;
    private final Analyzer analyzer_;
    private final PlannerContext plannerContext_;

    public CalcitePhysPlanCreator(CalciteMetadataHandler mdHandler, CalciteJniFrontend.QueryContext queryCtx) throws ImpalaException {
        this.queryCtx_ = queryCtx;
        AuthorizationFactory authzFactory = AuthorizationUtil.authzFactoryFrom((BackendConfig)BackendConfig.INSTANCE);
        this.analyzer_ = new Analyzer(mdHandler.getStmtTableCache(), this.queryCtx_.getTQueryCtx(), authzFactory, null);
        this.plannerContext_ = new PlannerContext(this.analyzer_, this.queryCtx_.getTQueryCtx(), this.queryCtx_.getTimeline());
    }

    public NodeWithExprs create(ImpalaPlanRel optimizedPlan) throws ImpalaException {
        ParentPlanRelContext rootContext = ParentPlanRelContext.createRootContext(this.plannerContext_);
        NodeWithExprs rootNodeWithExprs = optimizedPlan.getPlanNode(rootContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Printing PlanNode tree...");
            this.printPlanNodeTree(rootNodeWithExprs.planNode_, "");
        }
        return rootNodeWithExprs;
    }

    public void printPlanNodeTree(PlanNode node, String prefix) {
        LOG.debug(prefix + node.getClass());
        for (PlanNode child : node.getChildren()) {
            this.printPlanNodeTree(child, "  " + prefix);
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer_;
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext_;
    }

    @Override
    public void logDebug(Object resultObject) {
        if (!(resultObject instanceof NodeWithExprs)) {
            LOG.debug("Finished physical plan step, but unknown result: " + resultObject);
            return;
        }
        LOG.debug("Physical Plan: " + resultObject);
    }
}

