/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.impala.calcite.rel.node.ConvertToImpalaRelRules;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.service.CalciteValidator;
import org.apache.impala.calcite.service.CompilerStep;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteOptimizer
implements CompilerStep {
    protected static final Logger LOG = LoggerFactory.getLogger((String)CalciteOptimizer.class.getName());
    private final CalciteValidator validator_;

    public CalciteOptimizer(CalciteValidator validator) {
        this.validator_ = validator;
    }

    public ImpalaPlanRel optimize(RelNode logPlan) throws ImpalaException {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addRuleCollection((Collection)ImmutableList.of((Object)((Object)new ConvertToImpalaRelRules.ImpalaScanRule()), (Object)((Object)new ConvertToImpalaRelRules.ImpalaFilterRule()), (Object)((Object)new ConvertToImpalaRelRules.ImpalaSortRule()), (Object)((Object)new ConvertToImpalaRelRules.ImpalaValuesRule()), (Object)((Object)new ConvertToImpalaRelRules.ImpalaUnionRule()), (Object)((Object)new ConvertToImpalaRelRules.ImpalaProjectRule())));
        HepPlanner planner = new HepPlanner(builder.build(), logPlan.getCluster().getPlanner().getContext(), false, null, RelOptCostImpl.FACTORY);
        logPlan.getCluster().setMetadataProvider((RelMetadataProvider)JaninoRelMetadataProvider.DEFAULT);
        planner.setRoot(logPlan);
        RelNode optimizedPlan = planner.findBestExp();
        if (!(optimizedPlan instanceof ImpalaPlanRel)) {
            throw new InternalException("Could not generate Impala RelNode plan. Plan is \n" + this.getDebugString(optimizedPlan));
        }
        return (ImpalaPlanRel)optimizedPlan;
    }

    public String getDebugString(Object optimizedPlan) {
        return RelOptUtil.dumpPlan((String)"[Impala plan]", (RelNode)((RelNode)optimizedPlan), (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.NON_COST_ATTRIBUTES);
    }

    @Override
    public void logDebug(Object resultObject) {
        if (!(resultObject instanceof RelNode)) {
            LOG.debug("Finished optimizer step, but unknown result: " + resultObject);
            return;
        }
        LOG.debug(this.getDebugString(resultObject));
    }
}

