/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.analysis.TableName;
import org.apache.impala.calcite.schema.CalciteDb;
import org.apache.impala.calcite.schema.ImpalaCalciteCatalogReader;
import org.apache.impala.calcite.service.CalciteJniFrontend;
import org.apache.impala.calcite.service.CompilerStep;
import org.apache.impala.calcite.type.ImpalaTypeSystemImpl;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.ImpalaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteMetadataHandler
implements CompilerStep {
    protected static final Logger LOG = LoggerFactory.getLogger((String)CalciteMetadataHandler.class.getName());
    private final StmtMetadataLoader.StmtTableCache stmtTableCache_;
    private final CalciteCatalogReader reader_;

    public CalciteMetadataHandler(SqlNode parsedNode, CalciteJniFrontend.QueryContext queryCtx) throws ImpalaException {
        StmtMetadataLoader stmtMetadataLoader = new StmtMetadataLoader(queryCtx.getFrontend(), queryCtx.getCurrentDb(), queryCtx.getTimeline());
        TableVisitor tableVisitor = new TableVisitor(queryCtx.getCurrentDb());
        parsedNode.accept((SqlVisitor)tableVisitor);
        this.stmtTableCache_ = stmtMetadataLoader.loadTables(tableVisitor.tableNames_);
        this.reader_ = this.createCalciteCatalogReader(queryCtx, this.stmtTableCache_);
        this.populateCalciteSchema(this.reader_, queryCtx.getFrontend().getCatalog(), tableVisitor.tableNames_);
    }

    private CalciteCatalogReader createCalciteCatalogReader(CalciteJniFrontend.QueryContext queryCtx, StmtMetadataLoader.StmtTableCache stmtTableCache) {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl((RelDataTypeSystem)new ImpalaTypeSystemImpl());
        Properties props = new Properties();
        props.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), "false");
        CalciteConnectionConfigImpl config = new CalciteConnectionConfigImpl(props);
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)true);
        return new ImpalaCalciteCatalogReader(rootSchema, Collections.singletonList(queryCtx.getCurrentDb()), (RelDataTypeFactory)typeFactory, (CalciteConnectionConfig)config, queryCtx.getTQueryCtx(), stmtTableCache);
    }

    private void populateCalciteSchema(CalciteCatalogReader reader, FeCatalog catalog, Set<TableName> tableNames) {
        CalciteSchema rootSchema = reader.getRootSchema();
        HashMap<String, CalciteDb.Builder> dbSchemas = new HashMap<String, CalciteDb.Builder>();
        for (TableName tableName : tableNames) {
            FeTable feTable;
            FeDb db = catalog.getDb(tableName.getDb());
            if (db == null || (feTable = db.getTable(tableName.getTbl())) == null) continue;
            CalciteDb.Builder dbBuilder = dbSchemas.getOrDefault(tableName.getDb(), new CalciteDb.Builder(reader));
            dbBuilder.addTable(tableName.getTbl().toLowerCase(), feTable);
            dbSchemas.put(tableName.getDb().toLowerCase(), dbBuilder);
        }
        for (String dbName : dbSchemas.keySet()) {
            rootSchema.add(dbName, (Schema)((CalciteDb.Builder)dbSchemas.get(dbName.toLowerCase())).build());
        }
    }

    public StmtMetadataLoader.StmtTableCache getStmtTableCache() {
        return this.stmtTableCache_;
    }

    public CalciteCatalogReader getCalciteCatalogReader() {
        return this.reader_;
    }

    @Override
    public void logDebug(Object resultObject) {
        LOG.debug("Loaded tables: " + this.stmtTableCache_.tables.values().stream().map(feTable -> feTable.getName().toString()).collect(Collectors.joining(", ")));
    }

    private static class TableVisitor
    extends SqlBasicVisitor<Void> {
        private final String currentDb_;
        public final Set<TableName> tableNames_ = new HashSet<TableName>();

        public TableVisitor(String currentDb) {
            this.currentDb_ = currentDb.toLowerCase();
        }

        public Void visit(SqlCall call) {
            SqlSelect select;
            if (call.getKind() == SqlKind.SELECT && (select = (SqlSelect)call).getFrom() != null) {
                this.tableNames_.addAll(this.getTableNames(select.getFrom()));
            }
            return (Void)super.visit(call);
        }

        private List<TableName> getTableNames(SqlNode fromNode) {
            SqlBasicCall basicCall;
            ArrayList<TableName> localTableNames = new ArrayList<TableName>();
            if (fromNode instanceof SqlIdentifier) {
                String tableName = fromNode.toString();
                List parts = Splitter.on((char)'.').splitToList((CharSequence)tableName);
                if (parts.size() == 1) {
                    localTableNames.add(new TableName(this.currentDb_.toLowerCase(), ((String)parts.get(0)).toLowerCase()));
                } else if (parts.size() == 2) {
                    localTableNames.add(new TableName(((String)parts.get(0)).toLowerCase(), ((String)parts.get(1)).toLowerCase()));
                }
            }
            if (fromNode instanceof SqlJoin) {
                localTableNames.addAll(this.getTableNames(((SqlJoin)fromNode).getLeft()));
                localTableNames.addAll(this.getTableNames(((SqlJoin)fromNode).getRight()));
            }
            if (fromNode instanceof SqlBasicCall && (basicCall = (SqlBasicCall)fromNode).getKind().equals((Object)SqlKind.AS)) {
                localTableNames.addAll(this.getTableNames(basicCall.operand(0)));
            }
            return localTableNames;
        }
    }
}

