/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.service;

import java.util.regex.Pattern;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.sql.SqlNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.impala.calcite.operators.ImpalaOperatorTable;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.service.CalciteMetadataHandler;
import org.apache.impala.calcite.service.CalciteOptimizer;
import org.apache.impala.calcite.service.CalcitePhysPlanCreator;
import org.apache.impala.calcite.service.CalciteQueryParser;
import org.apache.impala.calcite.service.CalciteRelNodeConverter;
import org.apache.impala.calcite.service.CalciteValidator;
import org.apache.impala.calcite.service.CompilerStep;
import org.apache.impala.calcite.service.ExecRequestCreator;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.service.Frontend;
import org.apache.impala.service.FrontendProfile;
import org.apache.impala.service.JniFrontend;
import org.apache.impala.thrift.TExecRequest;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.util.EventSequence;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteJniFrontend
extends JniFrontend {
    protected static final Logger LOG = LoggerFactory.getLogger((String)CalciteJniFrontend.class.getName());
    private static final TBinaryProtocol.Factory protocolFactory_ = new TBinaryProtocol.Factory();
    private static Pattern SEMI_JOIN = Pattern.compile("\\bsemi\\sjoin\\b", 2);
    private static Pattern ANTI_JOIN = Pattern.compile("\\banti\\sjoin\\b", 2);

    public CalciteJniFrontend(byte[] thriftBackendConfig, boolean isBackendTest) throws ImpalaException, TException {
        super(thriftBackendConfig, isBackendTest);
        CalciteJniFrontend.loadCalciteImpalaFunctions();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] createExecRequest(byte[] thriftQueryContext) throws ImpalaException {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        QueryContext queryCtx = new QueryContext(thriftQueryContext, this.getFrontend());
        if (!this.canStmtBePlannedThroughCalcite(queryCtx)) {
            return this.runThroughOriginalPlanner(thriftQueryContext, queryCtx);
        }
        try (FrontendProfile.Scope scope = FrontendProfile.createNewWithScope();){
            LOG.info("Using Calcite Planner for the following query: " + queryCtx.getStmt());
            RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE));
            CalciteQueryParser queryParser = new CalciteQueryParser(queryCtx);
            SqlNode parsedSqlNode = queryParser.parse();
            this.markEvent(queryParser, parsedSqlNode, queryCtx, "Parsed query");
            CalciteMetadataHandler mdHandler = new CalciteMetadataHandler(parsedSqlNode, queryCtx);
            this.markEvent(mdHandler, null, queryCtx, "Loaded tables");
            CalciteValidator validator = new CalciteValidator(mdHandler, queryCtx);
            SqlNode validatedNode = validator.validate(parsedSqlNode);
            this.markEvent(mdHandler, validatedNode, queryCtx, "Validated query");
            CalciteRelNodeConverter relNodeConverter = new CalciteRelNodeConverter(validator);
            RelNode logicalPlan = relNodeConverter.convert(validatedNode);
            this.markEvent(mdHandler, logicalPlan, queryCtx, "Created initial logical plan");
            CalciteOptimizer optimizer = new CalciteOptimizer(validator);
            ImpalaPlanRel optimizedPlan = optimizer.optimize(logicalPlan);
            this.markEvent(mdHandler, optimizedPlan, queryCtx, "Optimized logical plan");
            CalcitePhysPlanCreator physPlanCreator = new CalcitePhysPlanCreator(mdHandler, queryCtx);
            NodeWithExprs rootNode = physPlanCreator.create(optimizedPlan);
            this.markEvent(mdHandler, rootNode, queryCtx, "Created physical plan");
            ExecRequestCreator execRequestCreator = new ExecRequestCreator(physPlanCreator, queryCtx, mdHandler);
            TExecRequest execRequest = execRequestCreator.create(rootNode);
            this.markEvent(mdHandler, execRequest, queryCtx, "Created exec request");
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            byte[] serializedRequest = serializer.serialize((TBase)execRequest);
            queryCtx.getTimeline().markEvent("Serialized request");
            byte[] byArray = serializedRequest;
            return byArray;
        }
        catch (Exception e) {
            LOG.info("Calcite planner failed.");
            LOG.info("Exception: " + e);
            if (e == null) throw new RuntimeException(e);
            LOG.info("Stack Trace:" + ExceptionUtils.getStackTrace((Throwable)e));
            throw new InternalException(e.getMessage());
        }
    }

    private boolean canStmtBePlannedThroughCalcite(QueryContext queryCtx) {
        String beforeStripString;
        String[] lines;
        String stringWithFirstRealWord = queryCtx.getStmt();
        for (String line : lines = stringWithFirstRealWord.split("\n")) {
            if (!line.trim().startsWith("--") && !line.trim().equals("")) break;
            stringWithFirstRealWord = stringWithFirstRealWord.replaceFirst(line + "\n", "");
        }
        stringWithFirstRealWord = stringWithFirstRealWord.trim();
        do {
            beforeStripString = stringWithFirstRealWord;
            stringWithFirstRealWord = StringUtils.stripStart((String)stringWithFirstRealWord, (String)"(");
        } while (!(stringWithFirstRealWord = StringUtils.stripStart((String)stringWithFirstRealWord, null)).equals(beforeStripString));
        return StringUtils.startsWithIgnoreCase((CharSequence)stringWithFirstRealWord, (CharSequence)"select") || StringUtils.startsWithIgnoreCase((CharSequence)stringWithFirstRealWord, (CharSequence)"values") || StringUtils.startsWithIgnoreCase((CharSequence)stringWithFirstRealWord, (CharSequence)"with");
    }

    public byte[] runThroughOriginalPlanner(byte[] thriftQueryContext, QueryContext queryCtx) throws ImpalaException {
        LOG.info("Using Impala Planner for the following query: " + queryCtx.getStmt());
        return super.createExecRequest(thriftQueryContext);
    }

    private void markEvent(CompilerStep compilerStep, Object stepResult, QueryContext queryCtx, String stepMessage) {
        LOG.info(stepMessage);
        queryCtx.getTimeline().markEvent(stepMessage);
        if (LOG.isDebugEnabled()) {
            compilerStep.logDebug(stepResult);
        }
    }

    private static void loadCalciteImpalaFunctions() {
        ImpalaOperatorTable.create(BuiltinsDb.getInstance());
    }

    public static class QueryContext {
        private final TQueryCtx queryCtx_ = new TQueryCtx();
        private final String stmt_;
        private final String currentDb_;
        private final Frontend frontend_;
        private final EventSequence timeline_;

        public QueryContext(byte[] thriftQueryContext, Frontend frontend) throws ImpalaException {
            JniUtil.deserializeThrift((TProtocolFactory)protocolFactory_, (TBase)this.queryCtx_, (byte[])thriftQueryContext);
            if (this.queryCtx_.getClient_request() != null && this.queryCtx_.getClient_request().getQuery_options() != null && !this.queryCtx_.getClient_request().getQuery_options().isSetMt_dop()) {
                this.queryCtx_.getClient_request().getQuery_options().setMt_dop(0);
            }
            this.frontend_ = frontend;
            this.stmt_ = this.queryCtx_.getClient_request().getStmt();
            this.currentDb_ = this.queryCtx_.getSession().getDatabase();
            this.timeline_ = new EventSequence("Frontend Timeline (Calcite Planner)");
        }

        public TQueryCtx getTQueryCtx() {
            return this.queryCtx_;
        }

        public Frontend getFrontend() {
            return this.frontend_;
        }

        public String getStmt() {
            return this.stmt_;
        }

        public String getCurrentDb() {
            return this.currentDb_;
        }

        public EventSequence getTimeline() {
            return this.timeline_;
        }
    }
}

