/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptAbstractTable;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlAccessType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BaseTableRef;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.calcite.type.ImpalaTypeSystemImpl;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.HdfsPartitionPruner;

public class CalciteTable
extends RelOptAbstractTable
implements Table,
Prepare.PreparingTable {
    private final HdfsTable table_;
    private final List<String> qualifiedTableName_;

    public CalciteTable(FeTable table, CalciteCatalogReader reader) {
        super((RelOptSchema)reader, table.getName(), CalciteTable.buildColumnsForRelDataType(table));
        this.table_ = (HdfsTable)table;
        this.qualifiedTableName_ = table.getTableName().toPath();
    }

    private static RelDataType buildColumnsForRelDataType(FeTable table) {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl((RelDataTypeSystem)new ImpalaTypeSystemImpl());
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory);
        for (Column column : table.getColumnsInHiveOrder()) {
            RelDataType type = ImpalaTypeConverter.createRelDataType((RelDataTypeFactory)typeFactory, column.getType());
            builder.add(column.getName(), type);
        }
        return builder.build();
    }

    public BaseTableRef createBaseTableRef(Analyzer analyzer) throws ImpalaException {
        TableRef tblRef = new TableRef(this.qualifiedTableName_, null);
        Path resolvedPath = analyzer.resolvePath(tblRef.getPath(), Path.PathType.TABLE_REF);
        BaseTableRef baseTblRef = new BaseTableRef(tblRef, resolvedPath);
        baseTblRef.analyze(analyzer);
        return baseTblRef;
    }

    public TupleDescriptor createTupleAndSlotDesc(BaseTableRef baseTblRef, List<String> fieldNames, Analyzer analyzer) throws ImpalaException {
        for (int i = 0; i < fieldNames.size(); ++i) {
            String fieldName = fieldNames.get(i);
            SlotRef slotref = new SlotRef(Path.createRawPath((String)baseTblRef.getUniqueAlias(), (String)fieldName));
            slotref.analyze(analyzer);
            SlotDescriptor slotDesc = slotref.getDesc();
            if (slotDesc.getType().isCollectionType()) {
                throw new AnalysisException(String.format(fieldName + " is a complex type (array/map/struct) column. This is not currently supported.", new Object[0]));
            }
            slotDesc.setIsMaterialized(true);
        }
        TupleDescriptor tupleDesc = baseTblRef.getDesc();
        return tupleDesc;
    }

    public List<? extends FeFsPartition> getPrunedPartitions(Analyzer analyzer, TupleDescriptor tupleDesc) throws ImpalaException {
        HdfsPartitionPruner pruner = new HdfsPartitionPruner(tupleDesc);
        ArrayList conjuncts = new ArrayList();
        Pair impalaPair = pruner.prunePartitions(analyzer, conjuncts, true, null);
        return (List)impalaPair.first;
    }

    public HdfsTable getHdfsTable() {
        return this.table_;
    }

    public List<String> getQualifiedName() {
        return this.qualifiedTableName_;
    }

    public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
        return true;
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TABLE;
    }

    public boolean isRolledUp(String column) {
        return false;
    }

    public Statistic getStatistic() {
        return null;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.getRowType();
    }

    public <T> T unwrap(Class<T> arg0) {
        return arg0.isInstance((Object)this) ? (T)arg0.cast((Object)this) : null;
    }

    public boolean columnHasDefaultValue(RelDataType rowType, int ordinal, InitializerContext initializerContext) {
        throw new UnsupportedOperationException();
    }

    public boolean isTemporal() {
        return false;
    }

    public boolean supportsModality(SqlModality modality) {
        return true;
    }

    public SqlAccessType getAllowedAccess() {
        return SqlAccessType.ALL;
    }

    public SqlMonotonicity getMonotonicity(String columnName) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }
}

