/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.schema;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.impala.calcite.schema.CalciteTable;
import org.apache.impala.catalog.FeTable;

public class CalciteDb
extends AbstractSchema {
    private final Map<String, Table> tableMap_;

    private CalciteDb(Map<String, Table> tableMap) {
        this.tableMap_ = tableMap;
    }

    protected Map<String, Table> getTableMap() {
        return this.tableMap_;
    }

    public static class Builder {
        private CalciteCatalogReader reader_;
        private final Map<String, Table> tableMap_ = new HashMap<String, Table>();

        public Builder(CalciteCatalogReader reader) {
            this.reader_ = reader;
        }

        public Builder addTable(String tableName, FeTable table) {
            if (!this.tableMap_.containsKey(tableName)) {
                this.tableMap_.put(tableName.toLowerCase(), new CalciteTable(table, this.reader_));
            }
            return this;
        }

        public CalciteDb build() {
            return new CalciteDb((Map)ImmutableMap.copyOf(this.tableMap_));
        }
    }
}

