/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.calcite.rel.util.CreateExprVisitor;
import org.apache.impala.common.ImpalaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprConjunctsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ExprConjunctsConverter.class);
    private final List<Expr> allConjuncts_;

    public ExprConjunctsConverter(RexNode conjunct, List<Expr> inputExprs, RexBuilder rexBuilder, Analyzer analyzer) throws ImpalaException {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        if (conjunct != null) {
            CreateExprVisitor visitor = new CreateExprVisitor(rexBuilder, inputExprs, analyzer);
            List<RexNode> andOperands = ExprConjunctsConverter.getAndConjuncts(conjunct);
            for (RexNode andOperand : andOperands) {
                Expr convertedExpr = CreateExprVisitor.getExpr(visitor, andOperand);
                builder.add((Object)convertedExpr);
            }
        }
        this.allConjuncts_ = builder.build();
    }

    public List<Expr> getImpalaConjuncts() {
        return this.allConjuncts_;
    }

    private static List<RexNode> getAndConjuncts(RexNode conjunct) {
        if (conjunct == null) {
            return ImmutableList.of();
        }
        if (!(conjunct instanceof RexCall)) {
            return ImmutableList.of((Object)conjunct);
        }
        RexCall rexCallConjunct = (RexCall)conjunct;
        if (rexCallConjunct.getKind() != SqlKind.AND) {
            return ImmutableList.of((Object)conjunct);
        }
        return rexCallConjunct.getOperands();
    }
}

