/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.calcite.functions.RexCallConverter;
import org.apache.impala.calcite.functions.RexLiteralConverter;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;

public class CreateExprVisitor
extends RexVisitorImpl<Expr> {
    private final RexBuilder rexBuilder_;
    private final List<Expr> inputExprs_;
    private final Analyzer analyzer_;

    public CreateExprVisitor(RexBuilder rexBuilder, List<Expr> inputExprs, Analyzer analyzer) {
        super(false);
        this.inputExprs_ = inputExprs;
        this.rexBuilder_ = rexBuilder;
        this.analyzer_ = analyzer;
    }

    public Expr visitInputRef(RexInputRef rexInputRef) {
        return this.inputExprs_.get(rexInputRef.getIndex());
    }

    public Expr visitCall(RexCall rexCall) {
        ArrayList params = Lists.newArrayList();
        for (RexNode operand : rexCall.getOperands()) {
            params.add(operand.accept((RexVisitor)this));
        }
        return RexCallConverter.getExpr(rexCall, params, this.rexBuilder_);
    }

    public Expr visitLiteral(RexLiteral rexLiteral) {
        return RexLiteralConverter.getExpr(rexLiteral);
    }

    public Expr visitLocalRef(RexLocalRef localRef) {
        throw new RuntimeException("Not supported");
    }

    public Expr visitOver(RexOver over) {
        throw new RuntimeException("Not supported");
    }

    public Expr visitCorrelVariable(RexCorrelVariable correlVariable) {
        throw new RuntimeException("Not supported");
    }

    public Expr visitDynamicParam(RexDynamicParam dynamicParam) {
        throw new RuntimeException("Not supported");
    }

    public Expr visitRangeRef(RexRangeRef rangeRef) {
        throw new RuntimeException("Not supported");
    }

    public Expr visitFieldAccess(RexFieldAccess fieldAccess) {
        throw new RuntimeException("Not supported");
    }

    public Expr visitSubQuery(RexSubQuery subQuery) {
        throw new RuntimeException("Not supported");
    }

    public Expr visitTableInputRef(RexTableInputRef fieldRef) {
        throw new RuntimeException("Not supported");
    }

    public Expr visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        throw new RuntimeException("Not supported");
    }

    public static Expr getExpr(CreateExprVisitor visitor, RexNode operand) throws ImpalaException {
        try {
            Expr expr = (Expr)operand.accept((RexVisitor)visitor);
            expr.analyze(visitor.analyzer_);
            return expr;
        }
        catch (Exception e) {
            throw new AnalysisException((Throwable)e);
        }
    }

    public static List<Expr> getExprs(CreateExprVisitor visitor, List<RexNode> operands) throws ImpalaException {
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        for (RexNode operand : operands) {
            exprs.add(CreateExprVisitor.getExpr(visitor, operand));
        }
        return exprs;
    }
}

