/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.node;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.impala.analysis.Expr;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeCreationUtils;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.rel.node.ParentPlanRelContext;
import org.apache.impala.calcite.rel.util.ExprConjunctsConverter;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;

public class ImpalaValuesRel
extends Values
implements ImpalaPlanRel {
    public ImpalaValuesRel(Values values) {
        super(values.getCluster(), values.getRowType(), values.getTuples(), values.getTraitSet());
    }

    @Override
    public NodeWithExprs getPlanNode(ParentPlanRelContext context) throws ImpalaException {
        if (context.parentType_ == ImpalaPlanRel.RelNodeType.UNION && this.getTuples().size() == 1) {
            return this.getValuesExprs(context, (List)this.getTuples().get(0));
        }
        PlanNodeId nodeId = context.ctx_.getNextNodeId();
        RelDataType rowType = this.getRowType();
        List<NodeWithExprs> nodeWithExprsList = this.getValuesExprs(context);
        NodeWithExprs retNode = NodeCreationUtils.createUnionPlanNode(nodeId, context.ctx_.getRootAnalyzer(), rowType, nodeWithExprsList);
        return NodeCreationUtils.wrapInSelectNodeIfNeeded(context, retNode, this.getCluster().getRexBuilder());
    }

    private List<NodeWithExprs> getValuesExprs(ParentPlanRelContext context) throws ImpalaException {
        ArrayList<NodeWithExprs> nodeWithExprsList = new ArrayList<NodeWithExprs>();
        for (List literals : this.getTuples()) {
            nodeWithExprsList.add(this.getValuesExprs(context, literals));
        }
        return nodeWithExprsList;
    }

    private NodeWithExprs getValuesExprs(ParentPlanRelContext context, List<RexLiteral> literals) throws ImpalaException {
        PlanNode retNode = null;
        ArrayList<Expr> outputExprs = new ArrayList<Expr>();
        for (RexLiteral literal : literals) {
            if (literal.getType().getSqlTypeName().equals((Object)SqlTypeName.CHAR)) {
                throw new AnalysisException("Char type values are not yet supported.");
            }
            ExprConjunctsConverter converter = new ExprConjunctsConverter((RexNode)literal, new ArrayList<Expr>(), this.getCluster().getRexBuilder(), context.ctx_.getRootAnalyzer());
            outputExprs.addAll(converter.getImpalaConjuncts());
        }
        return new NodeWithExprs(retNode, outputExprs);
    }

    @Override
    public ImpalaPlanRel.RelNodeType relNodeType() {
        return ImpalaPlanRel.RelNodeType.VALUES;
    }
}

