/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.node;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeCreationUtils;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.rel.node.ParentPlanRelContext;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.PlanNodeId;

public class ImpalaUnionRel
extends Union
implements ImpalaPlanRel {
    public ImpalaUnionRel(Union union) {
        super(union.getCluster(), union.getTraitSet(), union.getInputs(), union.all);
    }

    private ImpalaUnionRel(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
        super(cluster, traits, inputs, all);
    }

    public ImpalaUnionRel copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        return new ImpalaUnionRel(this.getCluster(), traitSet, inputs, all);
    }

    @Override
    public NodeWithExprs getPlanNode(ParentPlanRelContext context) throws ImpalaException {
        PlanNodeId nodeId = context.ctx_.getNextNodeId();
        RelDataType rowType = this.getRowType();
        List<NodeWithExprs> nodeWithExprsList = this.getChildrenPlanNodes(this.getInputs(), context);
        NodeWithExprs retNode = NodeCreationUtils.createUnionPlanNode(nodeId, context.ctx_.getRootAnalyzer(), rowType, nodeWithExprsList);
        return NodeCreationUtils.wrapInSelectNodeIfNeeded(context, retNode, this.getCluster().getRexBuilder());
    }

    private List<NodeWithExprs> getChildrenPlanNodes(List<RelNode> relInputs, ParentPlanRelContext context) throws ImpalaException {
        ArrayList<NodeWithExprs> childrenNodes = new ArrayList<NodeWithExprs>();
        for (RelNode input : relInputs) {
            ImpalaPlanRel inputRel = (ImpalaPlanRel)input;
            ParentPlanRelContext.Builder builder = new ParentPlanRelContext.Builder(context, this);
            builder.setFilterCondition(null);
            childrenNodes.add(inputRel.getPlanNode(builder.build()));
        }
        return childrenNodes;
    }

    @Override
    public ImpalaPlanRel.RelNodeType relNodeType() {
        return ImpalaPlanRel.RelNodeType.UNION;
    }
}

