/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SortInfo;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeCreationUtils;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.rel.node.ParentPlanRelContext;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.SortNode;
import org.apache.impala.thrift.TQueryOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaSortRel
extends Sort
implements ImpalaPlanRel {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaSortRel.class.getName());
    private final long limit_;
    private final long offset_;

    public ImpalaSortRel(Sort sort) {
        super(sort.getCluster(), sort.getTraitSet(), (List)sort.getHints(), sort.getInput(), sort.getCollation(), sort.offset, sort.fetch);
        this.limit_ = this.fetch != null ? ((BigDecimal)RexLiteral.value((RexNode)this.fetch)).longValue() : -1L;
        this.offset_ = this.offset != null ? ((BigDecimal)RexLiteral.value((RexNode)this.offset)).longValue() : 0L;
    }

    private ImpalaSortRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, new ArrayList(), newInput, newCollation, offset, fetch);
        this.limit_ = this.fetch != null ? ((BigDecimal)RexLiteral.value((RexNode)this.fetch)).longValue() : -1L;
        this.offset_ = this.offset != null ? ((BigDecimal)RexLiteral.value((RexNode)this.offset)).longValue() : 0L;
    }

    public Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new ImpalaSortRel(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
    }

    @Override
    public NodeWithExprs getPlanNode(ParentPlanRelContext context) throws ImpalaException {
        if (this.limit_ == 0L) {
            return NodeCreationUtils.createEmptySetPlanNode(context.ctx_.getNextNodeId(), context.ctx_.getRootAnalyzer(), this.getRowType());
        }
        List fieldCollations = this.getCollation().getFieldCollations();
        NodeWithExprs inputNodeWithExprs = this.getChildPlanNode(context);
        if (fieldCollations.size() == 0) {
            this.validateUnorderedLimit(context.filterCondition_, this.limit_, this.offset_);
            inputNodeWithExprs.planNode_.setLimit(this.limit_);
            return inputNodeWithExprs;
        }
        List<Expr> inputExprs = inputNodeWithExprs.outputExprs_;
        List isAscOrder = fieldCollations.stream().map(t -> t.direction == RelFieldCollation.Direction.ASCENDING).collect(Collectors.toList());
        List nullsFirstParams = fieldCollations.stream().map(t -> t.nullDirection == RelFieldCollation.NullDirection.FIRST).collect(Collectors.toList());
        List sortExprs = fieldCollations.stream().map(t -> this.getExpr(inputExprs, t.getFieldIndex())).collect(Collectors.toList());
        SortInfo sortInfo = new SortInfo(sortExprs, isAscOrder, nullsFirstParams);
        sortInfo.createSortTupleInfo(inputNodeWithExprs.outputExprs_, context.ctx_.getRootAnalyzer());
        List<Expr> outputExprs = this.createOutputExprs(sortInfo, inputNodeWithExprs.outputExprs_, context.ctx_.getRootAnalyzer());
        sortInfo.materializeRequiredSlots(context.ctx_.getRootAnalyzer(), new ExprSubstitutionMap());
        SortNode sortNode = ImpalaSortRel.createSortNode(context.ctx_, inputNodeWithExprs.planNode_, sortInfo, this.limit_, this.offset_, this.limit_ != -1L, context.ctx_.getRootAnalyzer());
        NodeWithExprs retNode = new NodeWithExprs((PlanNode)sortNode, outputExprs);
        return NodeCreationUtils.wrapInSelectNodeIfNeeded(context, retNode, this.getCluster().getRexBuilder());
    }

    private NodeWithExprs getChildPlanNode(ParentPlanRelContext context) throws ImpalaException {
        ImpalaPlanRel relInput = (ImpalaPlanRel)this.getInput(0);
        ParentPlanRelContext.Builder builder = new ParentPlanRelContext.Builder(context, this);
        builder.setFilterCondition(null);
        return relInput.getPlanNode(builder.build());
    }

    private Expr getExpr(List<Expr> exprs, int index) {
        return exprs.get(index);
    }

    private void validateUnorderedLimit(RexNode filterCondition, long limit, long offset) {
        Preconditions.checkArgument((filterCondition == null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.limit_ > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.offset_ == 0L ? 1 : 0) != 0);
    }

    public List<Expr> createOutputExprs(SortInfo sortInfo, List<Expr> outputExprs, Analyzer analyzer) throws AnalysisException {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Expr outputExpr : outputExprs) {
            builder.add((Object)outputExpr.trySubstitute(sortInfo.getOutputSmap(), analyzer, true));
        }
        for (SlotDescriptor slotDesc : sortInfo.getSortTupleDescriptor().getSlots()) {
            slotDesc.setIsMaterialized(true);
        }
        return builder.build();
    }

    public static SortNode createSortNode(PlannerContext planCtx, PlanNode root, SortInfo sortInfo, long limit, long offset, boolean hasLimit, Analyzer analyzer) throws ImpalaException {
        SortNode sortNode = ImpalaSortRel.createSortNode(planCtx, root, sortInfo, limit, offset, hasLimit);
        Preconditions.checkState((boolean)sortNode.hasValidStats());
        sortNode.setLimit(limit);
        sortNode.init(analyzer);
        return sortNode;
    }

    public static SortNode createSortNode(PlannerContext planCtx, PlanNode root, SortInfo sortInfo, long limit, long offset, boolean hasLimit) throws ImpalaException {
        if (!hasLimit) {
            return SortNode.createTotalSortNode((PlanNodeId)planCtx.getNextNodeId(), (PlanNode)root, (SortInfo)sortInfo, (long)offset);
        }
        return SortNode.createTopNSortNode((TQueryOptions)planCtx.getQueryOptions(), (PlanNodeId)planCtx.getNextNodeId(), (PlanNode)root, (SortInfo)sortInfo, (long)offset, (long)limit, (boolean)false);
    }

    @Override
    public ImpalaPlanRel.RelNodeType relNodeType() {
        return ImpalaPlanRel.RelNodeType.SORT;
    }
}

