/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.rel.node.ParentPlanRelContext;
import org.apache.impala.calcite.rel.util.CreateExprVisitor;
import org.apache.impala.common.ImpalaException;

public class ImpalaProjectRel
extends Project
implements ImpalaPlanRel {
    public ImpalaProjectRel(Project project) {
        super(project.getCluster(), project.getTraitSet(), project.getInput(), project.getProjects(), project.getRowType());
    }

    private ImpalaProjectRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traits, input, projects, rowType);
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new ImpalaProjectRel(this.getCluster(), traitSet, input, projects, rowType);
    }

    @Override
    public NodeWithExprs getPlanNode(ParentPlanRelContext context) throws ImpalaException {
        NodeWithExprs inputWithExprs = this.getChildPlanNode(context);
        List<Expr> outputExprs = this.createProjectExprs(context.ctx_.getRootAnalyzer(), inputWithExprs);
        return new NodeWithExprs(inputWithExprs.planNode_, outputExprs);
    }

    private List<Expr> createProjectExprs(Analyzer basicAnalyzer, NodeWithExprs inputNodeWithExprs) throws ImpalaException {
        ImpalaPlanRel inputRel = (ImpalaPlanRel)this.getInput(0);
        CreateExprVisitor visitor = new CreateExprVisitor(this.getCluster().getRexBuilder(), inputNodeWithExprs.outputExprs_, basicAnalyzer);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (RexNode rexNode : this.getProjects()) {
            Expr projectExpr = CreateExprVisitor.getExpr(visitor, rexNode);
            Preconditions.checkNotNull((Object)projectExpr, (String)"Visitor returned null Impala expr for RexNode %s", (Object)rexNode);
            builder.add((Object)projectExpr);
        }
        return builder.build();
    }

    private NodeWithExprs getChildPlanNode(ParentPlanRelContext context) throws ImpalaException {
        Preconditions.checkState((context.filterCondition_ == null ? 1 : 0) != 0, (Object)"Failure, Filter RelNode needs to be passed through the Project Rel Node.");
        ImpalaPlanRel relInput = (ImpalaPlanRel)this.getInput(0);
        ParentPlanRelContext.Builder builder = new ParentPlanRelContext.Builder(context, this);
        builder.setInputRefs(RelOptUtil.InputFinder.bits((List)this.getProjects(), null));
        return relInput.getPlanNode(builder.build());
    }

    @Override
    public ImpalaPlanRel.RelNodeType relNodeType() {
        return ImpalaPlanRel.RelNodeType.PROJECT;
    }
}

