/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.rel.node;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.core.TableScan;
import org.apache.impala.analysis.BaseTableRef;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.calcite.rel.node.ImpalaPlanRel;
import org.apache.impala.calcite.rel.node.NodeWithExprs;
import org.apache.impala.calcite.rel.node.ParentPlanRelContext;
import org.apache.impala.calcite.rel.phys.ImpalaHdfsScanNode;
import org.apache.impala.calcite.rel.util.ExprConjunctsConverter;
import org.apache.impala.calcite.schema.CalciteTable;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlanNodeId;

public class ImpalaHdfsScanRel
extends TableScan
implements ImpalaPlanRel {
    public ImpalaHdfsScanRel(TableScan scan) {
        super(scan.getCluster(), scan.getTraitSet(), (List)scan.getHints(), scan.getTable());
    }

    @Override
    public NodeWithExprs getPlanNode(ParentPlanRelContext context) throws ImpalaException {
        CalciteTable table = (CalciteTable)this.getTable();
        BaseTableRef baseTblRef = table.createBaseTableRef(context.ctx_.getRootAnalyzer());
        TupleDescriptor tupleDesc = table.createTupleAndSlotDesc(baseTblRef, this.getInputRefFieldNames(context), context.ctx_.getRootAnalyzer());
        List<Expr> outputExprs = this.createScanOutputExprs(tupleDesc.getSlots());
        ExprConjunctsConverter converter = new ExprConjunctsConverter(context.filterCondition_, outputExprs, this.getCluster().getRexBuilder(), context.ctx_.getRootAnalyzer());
        List<? extends FeFsPartition> impalaPartitions = table.getPrunedPartitions(context.ctx_.getRootAnalyzer(), tupleDesc);
        List<Expr> filterConjuncts = converter.getImpalaConjuncts();
        ArrayList<Expr> partitionConjuncts = new ArrayList<Expr>();
        PlanNodeId nodeId = context.ctx_.getNextNodeId();
        ImpalaHdfsScanNode physicalNode = new ImpalaHdfsScanNode(nodeId, tupleDesc, impalaPartitions, (TableRef)baseTblRef, null, partitionConjuncts, filterConjuncts);
        physicalNode.init(context.ctx_.getRootAnalyzer());
        return new NodeWithExprs((PlanNode)physicalNode, outputExprs);
    }

    private List<Expr> createScanOutputExprs(List<SlotDescriptor> slotDescs) {
        int totalCols = this.getRowType().getFieldNames().size();
        ArrayList<Object> scanOutputExprs = new ArrayList<Object>(Collections.nCopies(totalCols, null));
        HdfsTable table = ((CalciteTable)this.getTable()).getHdfsTable();
        Preconditions.checkState((totalCols == table.getColumns().size() ? 1 : 0) != 0);
        int nonPartitionedCols = totalCols - table.getNumClusteringCols();
        for (SlotDescriptor slotDesc : slotDescs) {
            int position = (slotDesc.getColumn().getPosition() + nonPartitionedCols) % totalCols;
            scanOutputExprs.set(position, new SlotRef(slotDesc));
        }
        return scanOutputExprs;
    }

    private List<String> getInputRefFieldNames(ParentPlanRelContext context) {
        if (context.inputRefs_ == null) {
            return this.getRowType().getFieldNames();
        }
        ArrayList<String> inputRefFieldNames = new ArrayList<String>();
        for (Integer i : context.inputRefs_) {
            inputRefFieldNames.add((String)this.getRowType().getFieldNames().get(i));
        }
        return inputRefFieldNames;
    }

    @Override
    public ImpalaPlanRel.RelNodeType relNodeType() {
        return ImpalaPlanRel.RelNodeType.HDFSSCAN;
    }
}

