/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.operators;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.util.ReflectiveSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.impala.calcite.operators.ImpalaOperator;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.catalog.Db;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaOperatorTable
extends ReflectiveSqlOperatorTable {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaOperatorTable.class.getName());
    private static ImpalaOperatorTable INSTANCE;

    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        SqlStdOperatorTable.instance().lookupOperatorOverloads(opName, category, syntax, operatorList, nameMatcher);
        Preconditions.checkState((operatorList.size() <= 1 ? 1 : 0) != 0);
        if (operatorList.size() == 1) {
            return;
        }
        if (opName.names.size() > 1) {
            throw new RuntimeException("Cannot handle identifier with more than one name: " + opName);
        }
        if (!BuiltinsDb.getInstance().containsFunction(opName.getSimple())) {
            return;
        }
        operatorList.add((SqlOperator)new ImpalaOperator(opName.getSimple()));
    }

    public static synchronized void create(Db db) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new ImpalaOperatorTable();
    }

    public static ImpalaOperatorTable getInstance() {
        return INSTANCE;
    }
}

