/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.operators;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.impala.calcite.functions.FunctionResolver;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.calcite.type.ImpalaTypeSystemImpl;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaOperator
extends SqlFunction {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ImpalaOperator.class.getName());
    public static SqlOperandCountRange ANY_COUNT_RANGE = SqlOperandCountRanges.any();

    public ImpalaOperator(String name) {
        super(name.toUpperCase(), SqlKind.OTHER, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION);
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        List<RelDataType> operandTypes = this.getOperandTypes(opBinding);
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl((RelDataTypeSystem)new ImpalaTypeSystemImpl()));
        RelDataTypeFactory factory = rexBuilder.getTypeFactory();
        Function fn = FunctionResolver.getFunction(this.getName(), operandTypes);
        if (fn == null) {
            throw new IllegalArgumentException("Cannot infer return type for " + this.getName() + "; operand types: " + operandTypes);
        }
        RelDataType returnType = ImpalaTypeConverter.getRelDataType(fn.getReturnType());
        return this.isNullable(operandTypes) ? returnType : factory.createTypeWithNullability(returnType, true);
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return true;
    }

    public SqlOperandCountRange getOperandCountRange() {
        return ANY_COUNT_RANGE;
    }

    public String getAllowedSignatures(String opNameToUse) {
        return "";
    }

    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION;
    }

    private List<RelDataType> getOperandTypes(SqlOperatorBinding opBinding) {
        Preconditions.checkState((boolean)(opBinding instanceof SqlCallBinding));
        SqlCallBinding callBinding = (SqlCallBinding)opBinding;
        ArrayList<RelDataType> operandTypes = new ArrayList<RelDataType>();
        for (int i = 0; i < callBinding.getOperandCount(); ++i) {
            if (callBinding.isOperandNull(i, false)) {
                operandTypes.add(ImpalaTypeConverter.getRelDataType((Type)Type.NULL));
                continue;
            }
            operandTypes.add(callBinding.getOperandType(i));
        }
        return operandTypes;
    }

    private boolean isNullable(List<RelDataType> operandTypes) {
        for (RelDataType rdt : operandTypes) {
            if (!rdt.isNullable()) continue;
            return true;
        }
        return false;
    }
}

