/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.impala.analysis.Expr;
import org.apache.impala.calcite.functions.AnalyzedFunctionCallExpr;
import org.apache.impala.calcite.functions.FunctionResolver;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RexCallConverter {
    protected static final Logger LOG = LoggerFactory.getLogger((String)RexCallConverter.class.getName());

    public static Expr getExpr(RexCall rexCall, List<Expr> params, RexBuilder rexBuilder) {
        String funcName = rexCall.getOperator().getName().toLowerCase();
        Function fn = RexCallConverter.getFunction(rexCall);
        Type impalaRetType = ImpalaTypeConverter.createImpalaType(fn.getReturnType(), rexCall.getType().getPrecision(), rexCall.getType().getScale());
        return new AnalyzedFunctionCallExpr(fn, params, rexCall, impalaRetType);
    }

    private static Function getFunction(RexCall call) {
        List argTypes = Lists.transform((List)call.getOperands(), RexNode::getType);
        String name = call.getOperator().getName();
        Function fn = FunctionResolver.getFunction(name, call.getKind(), argTypes);
        Preconditions.checkNotNull((Object)fn, (Object)("Could not find function \"" + name + "\" in Impala with args " + argTypes + " and return type " + call.getType()));
        return fn;
    }
}

