/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.calcite.functions;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlKind;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.calcite.type.ImpalaTypeConverter;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionResolver {
    protected static final Logger LOG = LoggerFactory.getLogger((String)FunctionResolver.class.getName());
    public static Map<SqlKind, String> CALCITE_KIND_TO_IMPALA_FUNC = ImmutableMap.builder().put((Object)SqlKind.EQUALS, (Object)"eq").put((Object)SqlKind.GREATER_THAN, (Object)"gt").put((Object)SqlKind.GREATER_THAN_OR_EQUAL, (Object)"ge").put((Object)SqlKind.LESS_THAN, (Object)"lt").put((Object)SqlKind.LESS_THAN_OR_EQUAL, (Object)"le").put((Object)SqlKind.NOT_EQUALS, (Object)"ne").build();

    public static Function getFunction(String name, SqlKind kind, List<RelDataType> argTypes) {
        String mappedName = CALCITE_KIND_TO_IMPALA_FUNC.get(kind);
        return mappedName == null ? FunctionResolver.getFunction(name, argTypes) : FunctionResolver.getFunction(mappedName, argTypes);
    }

    public static Function getFunction(String name, List<RelDataType> argTypes) {
        String lowercaseName = name.toLowerCase();
        List<Type> impalaArgTypes = ImpalaTypeConverter.getNormalizedImpalaTypes(argTypes);
        Function searchDesc = new Function(new FunctionName("_impala_builtins", lowercaseName), impalaArgTypes, (Type)Type.INVALID, false);
        Function fn = BuiltinsDb.getInstance().getFunction(searchDesc, Function.CompareMode.IS_INDISTINGUISHABLE);
        if (fn == null) {
            LOG.debug("Failed to find function " + lowercaseName);
        }
        return fn;
    }
}

