/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RCKUtils;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.iceberg.rest.RESTCatalogServer;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class RESTServerExtension
implements BeforeAllCallback,
AfterAllCallback {
    public static final String FREE_PORT = "0";
    private RESTCatalogServer localServer;
    private RESTCatalog client;
    private final Map<String, String> config;

    public RESTServerExtension() {
        this.config = Maps.newHashMap();
    }

    public RESTServerExtension(Map<String, String> config) {
        HashMap conf = Maps.newHashMap(config);
        if (conf.containsKey("rest.port") && ((String)conf.get("rest.port")).equals(FREE_PORT)) {
            conf.put("rest.port", String.valueOf(RCKUtils.findFreePort()));
        }
        this.config = conf;
    }

    public Map<String, String> config() {
        return this.config;
    }

    public RESTCatalog client() {
        return this.client;
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        if (Boolean.parseBoolean(extensionContext.getConfigurationParameter("rck.local").orElse("true"))) {
            this.localServer = new RESTCatalogServer(this.config);
            this.localServer.start(false);
            this.client = RCKUtils.initCatalogClient(this.config);
        }
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        if (this.localServer != null) {
            this.localServer.stop();
        }
        if (this.client != null) {
            this.client.close();
        }
    }
}

