/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import jakarta.servlet.Servlet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.jdbc.JdbcCatalog;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RCKUtils;
import org.apache.iceberg.rest.RESTCatalogAdapter;
import org.apache.iceberg.rest.RESTCatalogServlet;
import org.apache.iceberg.rest.RESTServerCatalogAdapter;
import org.apache.iceberg.util.PropertyUtil;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTCatalogServer {
    private static final Logger LOG = LoggerFactory.getLogger(RESTCatalogServer.class);
    public static final String REST_PORT = "rest.port";
    static final int REST_PORT_DEFAULT = 8181;
    private Server httpServer;
    private final Map<String, String> config;

    RESTCatalogServer() {
        this.config = Maps.newHashMap();
    }

    RESTCatalogServer(Map<String, String> config) {
        this.config = config;
    }

    private CatalogContext initializeBackendCatalog() throws IOException {
        HashMap catalogProperties = Maps.newHashMap(RCKUtils.environmentCatalogConfig());
        catalogProperties.putAll(this.config);
        catalogProperties.putIfAbsent("catalog-impl", JdbcCatalog.class.getName());
        catalogProperties.putIfAbsent("uri", "jdbc:sqlite::memory:");
        catalogProperties.putIfAbsent("jdbc.schema-version", "V1");
        String warehouseLocation = (String)catalogProperties.get("warehouse");
        if (warehouseLocation == null) {
            File tmp = Files.createTempDirectory("iceberg_warehouse", new FileAttribute[0]).toFile();
            tmp.deleteOnExit();
            warehouseLocation = tmp.toPath().resolve("iceberg_data").toFile().getAbsolutePath();
            catalogProperties.put("warehouse", warehouseLocation);
            LOG.info("No warehouse location set. Defaulting to temp location: {}", (Object)warehouseLocation);
        }
        LOG.info("Creating catalog with properties: {}", (Object)catalogProperties);
        return new CatalogContext(CatalogUtil.buildIcebergCatalog((String)"rest_backend", (Map)catalogProperties, (Object)new Configuration()), catalogProperties);
    }

    public void start(boolean join) throws Exception {
        CatalogContext catalogContext = this.initializeBackendCatalog();
        RESTServerCatalogAdapter adapter = new RESTServerCatalogAdapter(catalogContext);
        RESTCatalogServlet servlet = new RESTCatalogServlet((RESTCatalogAdapter)adapter);
        ServletContextHandler context = new ServletContextHandler(0);
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        context.addServlet(servletHolder, "/*");
        context.insertHandler((HandlerWrapper)new GzipHandler());
        this.httpServer = new Server(PropertyUtil.propertyAsInt(catalogContext.configuration, (String)REST_PORT, (int)8181));
        this.httpServer.setHandler((Handler)context);
        this.httpServer.start();
        if (join) {
            this.httpServer.join();
        }
    }

    public void stop() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
    }

    public static void main(String[] args) throws Exception {
        new RESTCatalogServer().start(true);
    }

    static class CatalogContext {
        private final Catalog catalog;
        private final Map<String, String> configuration;

        CatalogContext(Catalog catalog, Map<String, String> configuration) {
            this.catalog = catalog;
            this.configuration = configuration;
        }

        public Catalog catalog() {
            return this.catalog;
        }

        public Map<String, String> configuration() {
            return this.configuration;
        }
    }
}

