/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.iceberg.util.PropertyUtil;

class RCKUtils {
    private static final String CATALOG_ENV_PREFIX = "CATALOG_";
    static final String RCK_LOCAL = "rck.local";
    static final String RCK_PURGE_TEST_NAMESPACES = "rck.purge-test-namespaces";
    static final List<Namespace> TEST_NAMESPACES = List.of(Namespace.of((String[])new String[]{"ns"}), Namespace.of((String[])new String[]{"newdb"}));

    private RCKUtils() {
    }

    static Map<String, String> environmentCatalogConfig() {
        return System.getenv().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(CATALOG_ENV_PREFIX)).collect(Collectors.toMap(e -> ((String)e.getKey()).replaceFirst(CATALOG_ENV_PREFIX, "").replaceAll("__", "-").replaceAll("_", ".").toLowerCase(Locale.ROOT), Map.Entry::getValue, (m1, m2) -> {
            throw new IllegalArgumentException("Duplicate key: " + m1);
        }, HashMap::new));
    }

    static RESTCatalog initCatalogClient() {
        return RCKUtils.initCatalogClient(Maps.newHashMap());
    }

    static RESTCatalog initCatalogClient(Map<String, String> properties) {
        HashMap catalogProperties = Maps.newHashMap();
        catalogProperties.putAll(RCKUtils.environmentCatalogConfig());
        catalogProperties.putAll(Maps.fromProperties((Properties)System.getProperties()));
        catalogProperties.putAll(properties);
        String port = catalogProperties.getOrDefault("rest.port", String.valueOf(8181));
        catalogProperties.putIfAbsent("uri", String.format("http://localhost:%s/", port));
        catalogProperties.putIfAbsent("warehouse", "rck_warehouse");
        catalogProperties.putIfAbsent("table-default.default-key1", "catalog-default-key1");
        catalogProperties.putIfAbsent("table-default.default-key2", "catalog-default-key2");
        catalogProperties.putIfAbsent("view-default.key1", "catalog-default-key1");
        catalogProperties.putIfAbsent("view-default.key2", "catalog-default-key2");
        catalogProperties.putIfAbsent("view-default.key3", "catalog-default-key3");
        catalogProperties.putIfAbsent("view-override.key3", "catalog-override-key3");
        catalogProperties.putIfAbsent("view-override.key4", "catalog-override-key4");
        catalogProperties.putIfAbsent("table-default.override-key3", "catalog-default-key3");
        catalogProperties.putIfAbsent("table-override.override-key3", "catalog-override-key3");
        catalogProperties.putIfAbsent("table-override.override-key4", "catalog-override-key4");
        RESTCatalog catalog = new RESTCatalog();
        catalog.setConf((Object)new Configuration());
        catalog.initialize("rck_catalog", (Map)catalogProperties);
        return catalog;
    }

    static void purgeCatalogTestEntries(RESTCatalog catalog) {
        if (!PropertyUtil.propertyAsBoolean((Map)catalog.properties(), (String)RCK_PURGE_TEST_NAMESPACES, (boolean)true)) {
            return;
        }
        TEST_NAMESPACES.stream().filter(arg_0 -> ((RESTCatalog)catalog).namespaceExists(arg_0)).forEach(namespace -> {
            catalog.listTables(namespace).forEach(arg_0 -> ((RESTCatalog)catalog).dropTable(arg_0));
            catalog.listViews(namespace).forEach(arg_0 -> ((RESTCatalog)catalog).dropView(arg_0));
            catalog.dropNamespace(namespace);
        });
    }

    static int findFreePort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        socket.close();
        return n;
    }
}

