/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.view.ImmutableSQLViewRepresentation;
import org.apache.iceberg.view.ImmutableViewVersion;
import org.apache.iceberg.view.ViewRepresentation;
import org.apache.iceberg.view.ViewVersion;
import org.apache.iceberg.view.ViewVersionParser;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestViewVersionParser {
    @Test
    public void testParseViewVersion() {
        ImmutableSQLViewRepresentation firstRepresentation = ImmutableSQLViewRepresentation.builder().sql("select * from foo").dialect("spark-sql").build();
        ImmutableSQLViewRepresentation secondRepresentation = ImmutableSQLViewRepresentation.builder().sql("select a, b, c from foo").dialect("some-sql").build();
        ImmutableViewVersion expectedViewVersion = ImmutableViewVersion.builder().versionId(1).timestampMillis(12345L).addRepresentations(new ViewRepresentation[]{firstRepresentation, secondRepresentation}).summary((Map)ImmutableMap.of((Object)"operation", (Object)"create", (Object)"user", (Object)"some-user")).schemaId(1).build();
        String serializedRepresentations = "[{\"type\":\"sql\", \"sql\":\"select * from foo\", \"dialect\":\"spark-sql\"}, {\"type\":\"sql\", \"sql\":\"select a, b, c from foo\", \"dialect\":\"some-sql\"}]";
        String serializedViewVersion = String.format("{\"version-id\":1, \"timestamp-ms\":12345, \"schema-id\":1, \"summary\":{\"operation\":\"create\", \"user\":\"some-user\"}, \"representations\":%s}", serializedRepresentations);
        Assert.assertEquals((String)"Should be able to parse valid view version", (Object)expectedViewVersion, (Object)ViewVersionParser.fromJson((String)serializedViewVersion));
    }

    @Test
    public void testSerializeViewVersion() {
        ImmutableSQLViewRepresentation firstRepresentation = ImmutableSQLViewRepresentation.builder().sql("select * from foo").dialect("spark-sql").build();
        ImmutableSQLViewRepresentation secondRepresentation = ImmutableSQLViewRepresentation.builder().sql("select a, b, c from foo").dialect("some-sql").build();
        ImmutableViewVersion viewVersion = ImmutableViewVersion.builder().versionId(1).timestampMillis(12345L).addRepresentations(new ViewRepresentation[]{firstRepresentation, secondRepresentation}).summary((Map)ImmutableMap.of((Object)"operation", (Object)"create", (Object)"user", (Object)"some-user")).schemaId(1).build();
        String expectedRepresentations = "[{\"type\":\"sql\",\"sql\":\"select * from foo\",\"dialect\":\"spark-sql\"},{\"type\":\"sql\",\"sql\":\"select a, b, c from foo\",\"dialect\":\"some-sql\"}]";
        String expectedViewVersion = String.format("{\"version-id\":1,\"timestamp-ms\":12345,\"schema-id\":1,\"summary\":{\"operation\":\"create\",\"user\":\"some-user\"},\"representations\":%s}", expectedRepresentations);
        Assert.assertEquals((String)"Should be able to serialize valid view version", (Object)expectedViewVersion, (Object)ViewVersionParser.toJson((ViewVersion)viewVersion));
    }

    @Test
    public void testFailParsingMissingOperation() {
        String serializedRepresentations = "[{\"type\":\"sql\",\"sql\":\"select * from foo\",\"dialect\":\"spark-sql\"},{\"type\":\"sql\",\"sql\":\"select a, b, c from foo\",\"dialect\":\"some-sql\"}]";
        String viewVersionMissingOperation = String.format("{\"version-id\":1,\"timestamp-ms\":12345,\"summary\":{\"some-other-field\":\"some-other-value\"},\"representations\":%s,\"schema-id\":1}", serializedRepresentations);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ViewVersionParser.fromJson((String)viewVersionMissingOperation)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid view version summary, missing operation");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ImmutableViewVersion.builder().versionId(1).timestampMillis(12345L).schemaId(1).summary((Map)ImmutableMap.of((Object)"user", (Object)"some-user")).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid view version summary, missing operation");
    }

    @Test
    public void testNullViewVersion() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ViewVersionParser.toJson(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot serialize null view version");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ViewVersionParser.fromJson((JsonNode)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse view version from null object");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ViewVersionParser.fromJson((String)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse view version from null string");
    }
}

