/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import org.apache.iceberg.view.ImmutableUnknownViewRepresentation;
import org.apache.iceberg.view.ViewRepresentation;
import org.apache.iceberg.view.ViewRepresentationParser;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestViewRepresentationParser {
    @Test
    public void testParseUnknownViewRepresentation() {
        String json = "{\"type\":\"unknown-sql-representation\"}";
        ViewRepresentation unknownRepresentation = ViewRepresentationParser.fromJson((String)json);
        Assert.assertEquals((Object)unknownRepresentation, (Object)ImmutableUnknownViewRepresentation.builder().type("unknown-sql-representation").build());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ViewRepresentationParser.toJson((ViewRepresentation)unknownRepresentation)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Cannot serialize unsupported view representation: unknown-sql-representation");
    }

    @Test
    public void testNullViewRepresentation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ViewRepresentationParser.toJson(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid view representation: null");
    }

    @Test
    public void testViewRepresentationMissingType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ViewRepresentationParser.fromJson((String)"{\"sql\":\"select * from foo\"}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing string: type");
    }
}

