/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.view.ImmutableViewHistoryEntry;
import org.apache.iceberg.view.ViewHistoryEntry;
import org.apache.iceberg.view.ViewHistoryEntryParser;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestViewHistoryEntryParser {
    @Test
    public void testViewHistoryEntryFromJson() {
        String json = "{\"timestamp-ms\":123,\"version-id\":1}";
        ImmutableViewHistoryEntry viewHistoryEntry = ImmutableViewHistoryEntry.builder().versionId(1).timestampMillis(123L).build();
        Assert.assertEquals((String)"Should be able to deserialize valid view history entry", (Object)viewHistoryEntry, (Object)ViewHistoryEntryParser.fromJson((String)json));
    }

    @Test
    public void testViewHistoryEntryToJson() {
        String json = "{\"timestamp-ms\":123,\"version-id\":1}";
        ImmutableViewHistoryEntry viewHistoryEntry = ImmutableViewHistoryEntry.builder().versionId(1).timestampMillis(123L).build();
        Assert.assertEquals((String)"Should be able to serialize view history entry", (Object)json, (Object)ViewHistoryEntryParser.toJson((ViewHistoryEntry)viewHistoryEntry));
    }

    @Test
    public void testNullViewHistoryEntry() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ViewHistoryEntryParser.fromJson((JsonNode)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse view history entry from null object");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ViewHistoryEntryParser.toJson(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid view history entry: null");
    }

    @Test
    public void testViewHistoryEntryMissingFields() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ViewHistoryEntryParser.fromJson((String)"{}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing int: version-id");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ViewHistoryEntryParser.fromJson((String)"{\"timestamp-ms\":\"123\"}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing int: version-id");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ViewHistoryEntryParser.fromJson((String)"{\"version-id\":1}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing long: timestamp-ms");
    }
}

