/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.view.ImmutableSQLViewRepresentation;
import org.apache.iceberg.view.SQLViewRepresentationParser;
import org.apache.iceberg.view.ViewRepresentation;
import org.apache.iceberg.view.ViewRepresentationParser;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestSQLViewRepresentationParser {
    @Test
    public void testParseSqlViewRepresentation() {
        String requiredFields = "{\"type\":\"sql\", \"sql\": \"select * from foo\", \"dialect\": \"spark-sql\"}";
        ImmutableSQLViewRepresentation viewRepresentation = ImmutableSQLViewRepresentation.builder().sql("select * from foo").dialect("spark-sql").build();
        Assert.assertEquals((String)"Should be able to parse valid SQL view representation", (Object)viewRepresentation, (Object)SQLViewRepresentationParser.fromJson((String)requiredFields));
        String requiredAndOptionalFields = "{\"type\":\"sql\", \"sql\": \"select * from foo\", \"dialect\": \"spark-sql\", \"default-catalog\":\"cat\", \"default-namespace\":[\"part1\",\"part2\"], \"field-aliases\":[\"col1\", \"col2\"], \"field-comments\":[\"Comment col1\", \"Comment col2\"]}";
        ImmutableSQLViewRepresentation viewWithOptionalFields = ImmutableSQLViewRepresentation.builder().sql("select * from foo").dialect("spark-sql").defaultCatalog("cat").fieldAliases((Iterable)ImmutableList.of((Object)"col1", (Object)"col2")).fieldComments((Iterable)ImmutableList.of((Object)"Comment col1", (Object)"Comment col2")).defaultNamespace(Namespace.of((String[])new String[]{"part1", "part2"})).build();
        Assert.assertEquals((String)"Should be able to parse valid SQL view representation", (Object)viewWithOptionalFields, (Object)SQLViewRepresentationParser.fromJson((String)requiredAndOptionalFields));
    }

    @Test
    public void testParseSqlViewRepresentationMissingRequiredFields() {
        String missingDialect = "{\"type\":\"sql\", \"sql\": \"select * from foo\"}";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ViewRepresentationParser.fromJson((String)missingDialect)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing string: dialect");
        String missingType = "{\"sql\":\"select * from foo\",\"dialect\":\"spark-sql\"}";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ViewRepresentationParser.fromJson((String)missingType)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing string: type");
    }

    @Test
    public void testViewRepresentationSerialization() {
        String requiredFields = "{\"type\":\"sql\",\"sql\":\"select * from foo\",\"dialect\":\"spark-sql\"}";
        ImmutableSQLViewRepresentation viewRepresentation = ImmutableSQLViewRepresentation.builder().sql("select * from foo").dialect("spark-sql").build();
        Assert.assertEquals((String)"Should be able to serialize valid SQL view representation", (Object)requiredFields, (Object)ViewRepresentationParser.toJson((ViewRepresentation)viewRepresentation));
        String requiredAndOptionalFields = "{\"type\":\"sql\",\"sql\":\"select * from foo\",\"dialect\":\"spark-sql\",\"default-catalog\":\"cat\",\"default-namespace\":[\"part1\",\"part2\"],\"field-aliases\":[\"col1\",\"col2\"],\"field-comments\":[\"Comment col1\",\"Comment col2\"]}";
        ImmutableSQLViewRepresentation viewWithOptionalFields = ImmutableSQLViewRepresentation.builder().sql("select * from foo").dialect("spark-sql").defaultCatalog("cat").fieldAliases((Iterable)ImmutableList.of((Object)"col1", (Object)"col2")).fieldComments((Iterable)ImmutableList.of((Object)"Comment col1", (Object)"Comment col2")).defaultNamespace(Namespace.of((String[])new String[]{"part1", "part2"})).build();
        Assert.assertEquals((String)"Should be able to serialize valid SQL view representation", (Object)requiredAndOptionalFields, (Object)ViewRepresentationParser.toJson((ViewRepresentation)viewWithOptionalFields));
    }

    @Test
    public void testNullSqlViewRepresentation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SQLViewRepresentationParser.toJson(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid SQL view representation: null");
    }
}

