/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.stream.IntStream;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.DefaultMetricsContext;
import org.apache.iceberg.util.Tasks;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestTasks {
    @Test
    public void attemptCounterIsIncreasedOnRetries() {
        Counter counter = new DefaultMetricsContext().counter("counter");
        int retries = 10;
        Tasks.foreach((Object[])new IntStream[]{IntStream.range(0, 10)}).countAttempts(counter).exponentialBackoff(0L, 0L, 5000L, 0.0).retry(10).onlyRetryOn(RuntimeException.class).run(x -> {
            if (counter.value() <= 10L) {
                throw new RuntimeException();
            }
        });
        Assertions.assertThat((long)counter.value()).isEqualTo(11L);
    }

    @Test
    public void attemptCounterIsIncreasedWithoutRetries() {
        Counter counter = new DefaultMetricsContext().counter("counter");
        Tasks.foreach((Object[])new IntStream[]{IntStream.range(0, 10)}).countAttempts(counter).run(x -> {});
        Assertions.assertThat((long)counter.value()).isEqualTo(1L);
    }
}

