/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MergeableScanTask;
import org.apache.iceberg.MockFileScanTask;
import org.apache.iceberg.PartitionScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SplittableScanTask;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.TableScanUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTableScanUtil {
    private static final Schema TEST_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"c2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c3", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"c4", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC1 = PartitionSpec.builderFor((Schema)TEST_SCHEMA).identity("c1").identity("c2").build();
    private static final PartitionSpec SPEC2 = PartitionSpec.builderFor((Schema)TEST_SCHEMA).identity("c1").identity("c3").identity("c2").build();
    private static final StructLike PARTITION1 = new TestStructLike(100, "a");
    private static final StructLike PARTITION2 = new TestStructLike(200, "b");

    private List<FileScanTask> tasksWithDataAndDeleteSizes(List<Pair<Long, Long[]>> sizePairs) {
        return sizePairs.stream().map(sizePair -> {
            DataFile dataFile = this.dataFileWithSize((Long)sizePair.first());
            DeleteFile[] deleteFiles = this.deleteFilesWithSizes(Arrays.stream((Long[])sizePair.second()).mapToLong(Long::longValue).toArray());
            return new MockFileScanTask(dataFile, deleteFiles);
        }).collect(Collectors.toList());
    }

    private DataFile dataFileWithSize(long size) {
        DataFile mockFile = (DataFile)Mockito.mock(DataFile.class);
        Mockito.when((Object)mockFile.fileSizeInBytes()).thenReturn((Object)size);
        return mockFile;
    }

    private DeleteFile[] deleteFilesWithSizes(long ... sizes) {
        return (DeleteFile[])Arrays.stream(sizes).mapToObj(size -> {
            DeleteFile mockDeleteFile = (DeleteFile)Mockito.mock(DeleteFile.class);
            Mockito.when((Object)mockDeleteFile.fileSizeInBytes()).thenReturn((Object)size);
            return mockDeleteFile;
        }).toArray(DeleteFile[]::new);
    }

    @Test
    public void testPlanTaskWithDeleteFiles() {
        List<FileScanTask> testFiles = this.tasksWithDataAndDeleteSizes(Arrays.asList(Pair.of((Object)150L, (Object)new Long[]{50L, 100L}), Pair.of((Object)50L, (Object)new Long[]{1L, 50L}), Pair.of((Object)50L, (Object)new Long[]{100L}), Pair.of((Object)1L, (Object)new Long[]{1L, 1L}), Pair.of((Object)75L, (Object)new Long[]{75L})));
        ArrayList combinedScanTasks = Lists.newArrayList((Iterable)TableScanUtil.planTasks((CloseableIterable)CloseableIterable.withNoopClose(testFiles), (long)300L, (int)3, (long)50L));
        List<CombinedScanTask> expectedCombinedTasks = Arrays.asList(new BaseCombinedScanTask(Collections.singletonList(testFiles.get(0))), new BaseCombinedScanTask(Arrays.asList(testFiles.get(1), testFiles.get(2))), new BaseCombinedScanTask(Arrays.asList(testFiles.get(3), testFiles.get(4))));
        Assert.assertEquals((String)"Should plan 3 Combined tasks since there is delete files to be considered", (long)3L, (long)combinedScanTasks.size());
        for (int i = 0; i < expectedCombinedTasks.size(); ++i) {
            Assert.assertEquals((String)"Scan tasks detail in combined task check failed", (Object)expectedCombinedTasks.get(i).files(), (Object)((CombinedScanTask)combinedScanTasks.get(i)).files());
        }
    }

    @Test
    public void testTaskGroupPlanning() {
        ImmutableList tasks = ImmutableList.of((Object)new ChildTask1(64L), (Object)new ChildTask1(32L), (Object)new ChildTask3(64L), (Object)new ChildTask3(32L), (Object)new ChildTask2(128L), (Object)new ChildTask3(32L), (Object)new ChildTask3(32L));
        CloseableIterable taskGroups = TableScanUtil.planTaskGroups((CloseableIterable)CloseableIterable.withNoopClose((Iterable)tasks), (long)128L, (int)10, (long)4L);
        Assert.assertEquals((String)"Must have 3 task groups", (long)3L, (long)Iterables.size((Iterable)taskGroups));
    }

    @Test
    public void testTaskMerging() {
        ImmutableList tasks = ImmutableList.of((Object)new ChildTask1(64L), (Object)new ChildTask1(64L), (Object)new ChildTask2(128L), (Object)new ChildTask3(32L), (Object)new ChildTask3(32L));
        List mergedTasks = TableScanUtil.mergeTasks((List)tasks);
        Assert.assertEquals((String)"Appropriate tasks should be merged", (long)3L, (long)mergedTasks.size());
    }

    @Test
    public void testTaskGroupPlanningByPartition() {
        ImmutableList tasks = ImmutableList.of((Object)this.taskWithPartition(SPEC1, PARTITION1, 64L), (Object)this.taskWithPartition(SPEC1, PARTITION1, 128L), (Object)this.taskWithPartition(SPEC1, PARTITION1, 64L), (Object)this.taskWithPartition(SPEC1, PARTITION1, 128L));
        int count = 0;
        for (ScanTaskGroup task : TableScanUtil.planTaskGroups((List)tasks, (long)512L, (int)10, (long)4L, (Types.StructType)SPEC1.partitionType())) {
            Assert.assertEquals((long)4L, (long)task.filesCount());
            Assert.assertEquals((long)384L, (long)task.sizeBytes());
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        tasks = ImmutableList.of((Object)this.taskWithPartition(SPEC1, PARTITION1, 64L), (Object)this.taskWithPartition(SPEC1, PARTITION1, 128L), (Object)this.taskWithPartition(SPEC1, PARTITION2, 64L), (Object)this.taskWithPartition(SPEC1, PARTITION2, 128L));
        count = 0;
        for (ScanTaskGroup task : TableScanUtil.planTaskGroups((List)tasks, (long)512L, (int)10, (long)4L, (Types.StructType)SPEC1.partitionType())) {
            Assert.assertEquals((long)2L, (long)task.filesCount());
            Assert.assertEquals((long)192L, (long)task.sizeBytes());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        tasks = ImmutableList.of((Object)this.taskWithPartition(SPEC1, PARTITION1, 64L), (Object)this.taskWithPartition(SPEC2, PARTITION1, 128L), (Object)this.taskWithPartition(SPEC1, PARTITION2, 64L), (Object)this.taskWithPartition(SPEC2, PARTITION2, 128L));
        count = 0;
        for (ScanTaskGroup task : TableScanUtil.planTaskGroups((List)tasks, (long)512L, (int)10, (long)4L, (Types.StructType)SPEC1.partitionType())) {
            Assert.assertEquals((long)2L, (long)task.filesCount());
            Assert.assertEquals((long)192L, (long)task.sizeBytes());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        tasks = ImmutableList.of((Object)this.taskWithPartition(SPEC1, PARTITION1, 128L), (Object)this.taskWithPartition(SPEC2, PARTITION1, 128L), (Object)this.taskWithPartition(SPEC1, PARTITION2, 128L), (Object)this.taskWithPartition(SPEC2, PARTITION2, 128L));
        count = 0;
        for (ScanTaskGroup task : TableScanUtil.planTaskGroups((List)tasks, (long)128L, (int)10, (long)4L, (Types.StructType)SPEC1.partitionType())) {
            Assert.assertEquals((long)1L, (long)task.filesCount());
            Assert.assertEquals((long)128L, (long)task.sizeBytes());
            ++count;
        }
        Assert.assertEquals((long)4L, (long)count);
        ImmutableList tasks2 = ImmutableList.of((Object)this.taskWithPartition(SPEC1, PARTITION1, 128L), (Object)this.taskWithPartition(SPEC2, PARTITION2, 128L));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestTableScanUtil.lambda$testTaskGroupPlanningByPartition$3((List)tasks2)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot find field");
    }

    private PartitionScanTask taskWithPartition(PartitionSpec spec, StructLike partition, long sizeBytes) {
        PartitionScanTask task = (PartitionScanTask)Mockito.mock(PartitionScanTask.class);
        Mockito.when((Object)task.spec()).thenReturn((Object)spec);
        Mockito.when((Object)task.partition()).thenReturn((Object)partition);
        Mockito.when((Object)task.sizeBytes()).thenReturn((Object)sizeBytes);
        Mockito.when((Object)task.filesCount()).thenReturn((Object)1);
        return task;
    }

    private static /* synthetic */ void lambda$testTaskGroupPlanningByPartition$3(List tasks2) throws Throwable {
        TableScanUtil.planTaskGroups((List)tasks2, (long)128L, (int)10, (long)4L, (Types.StructType)SPEC2.partitionType());
    }

    private static class ChildTask3
    implements ParentTask,
    MergeableScanTask<ChildTask3> {
        private final long sizeBytes;

        ChildTask3(long sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        public boolean canMerge(ScanTask other) {
            return other instanceof ChildTask3;
        }

        public ChildTask3 merge(ScanTask other) {
            ChildTask3 that = (ChildTask3)other;
            return new ChildTask3(this.sizeBytes + that.sizeBytes);
        }

        public long sizeBytes() {
            return this.sizeBytes;
        }
    }

    private static class ChildTask2
    implements ParentTask,
    SplittableScanTask<ChildTask2> {
        private final long sizeBytes;

        ChildTask2(long sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        public Iterable<ChildTask2> split(long targetSplitSize) {
            return ImmutableList.of((Object)new ChildTask2(this.sizeBytes / 2L), (Object)new ChildTask2(this.sizeBytes / 2L));
        }

        public long sizeBytes() {
            return this.sizeBytes;
        }
    }

    private static class ChildTask1
    implements ParentTask,
    SplittableScanTask<ChildTask1>,
    MergeableScanTask<ChildTask1> {
        private final long sizeBytes;

        ChildTask1(long sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        public Iterable<ChildTask1> split(long targetSplitSize) {
            return ImmutableList.of((Object)new ChildTask1(this.sizeBytes / 2L), (Object)new ChildTask1(this.sizeBytes / 2L));
        }

        public boolean canMerge(ScanTask other) {
            return other instanceof ChildTask1;
        }

        public ChildTask1 merge(ScanTask other) {
            ChildTask1 that = (ChildTask1)other;
            return new ChildTask1(this.sizeBytes + that.sizeBytes);
        }

        public long sizeBytes() {
            return this.sizeBytes;
        }
    }

    private static interface ParentTask
    extends ScanTask {
    }

    private static class TestStructLike
    implements StructLike {
        private final Object[] values;

        TestStructLike(Object ... values) {
            this.values = values;
        }

        public int size() {
            return this.values.length;
        }

        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.values[pos]);
        }

        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("set is not supported");
        }
    }
}

