/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.junit.Assert;
import org.junit.Test;

public class TestStructLikeSet {
    private static final Types.StructType STRUCT_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.LongType.get())});

    @Test
    public void testNullElements() {
        StructLikeSet set = StructLikeSet.create((Types.StructType)STRUCT_TYPE);
        Assert.assertFalse((boolean)set.contains(null));
        set.add(null);
        Assert.assertTrue((boolean)set.contains(null));
        boolean added = set.add(null);
        Assert.assertFalse((boolean)added);
        boolean removed = set.remove(null);
        Assert.assertTrue((boolean)removed);
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testElementsWithNulls() {
        GenericRecord recordTemplate = GenericRecord.create((Types.StructType)STRUCT_TYPE);
        Record record1 = recordTemplate.copy("id", (Object)1, "data", null);
        Record record2 = recordTemplate.copy("id", (Object)2, "data", null);
        StructLikeSet set = StructLikeSet.create((Types.StructType)STRUCT_TYPE);
        set.add(record1);
        set.add(record2);
        Assert.assertTrue((boolean)set.contains(record1));
        Assert.assertTrue((boolean)set.contains(record2));
        Record record3 = record1.copy();
        Assert.assertTrue((boolean)set.contains(record3));
        boolean removed = set.remove(record3);
        Assert.assertTrue((boolean)removed);
    }
}

