/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeMap;
import org.junit.Assert;
import org.junit.Test;

public class TestStructLikeMap {
    private static final Types.StructType STRUCT_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.LongType.get())});

    @Test
    public void testSingleRecord() {
        block0: {
            GenericRecord gRecord = GenericRecord.create((Types.StructType)STRUCT_TYPE);
            Record record1 = gRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)1, (Object)"data", (Object)"aaa"));
            StructLikeMap map = StructLikeMap.create((Types.StructType)STRUCT_TYPE);
            Assert.assertEquals((long)0L, (long)map.size());
            map.put(record1, "1-aaa");
            Assert.assertEquals((long)1L, (long)map.size());
            Assert.assertFalse((boolean)map.isEmpty());
            Assert.assertTrue((boolean)map.containsKey(record1));
            Assert.assertTrue((boolean)map.containsValue("1-aaa"));
            Assert.assertEquals((Object)"1-aaa", map.get(record1));
            Set keySet = map.keySet();
            Assert.assertEquals((long)1L, (long)keySet.size());
            Assert.assertTrue((boolean)keySet.contains(record1));
            Collection values = map.values();
            Assert.assertEquals((long)1L, (long)values.size());
            Assert.assertEquals((Object)"1-aaa", (Object)values.toArray(new String[0])[0]);
            Set entrySet = map.entrySet();
            Assert.assertEquals((long)1L, (long)entrySet.size());
            Iterator iterator = entrySet.iterator();
            if (!iterator.hasNext()) break block0;
            Map.Entry entry = iterator.next();
            Assert.assertEquals((Object)record1, entry.getKey());
            Assert.assertEquals((Object)"1-aaa", entry.getValue());
        }
    }

    @Test
    public void testMultipleRecord() {
        GenericRecord gRecord = GenericRecord.create((Types.StructType)STRUCT_TYPE);
        Record record1 = gRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)1, (Object)"data", (Object)"aaa"));
        Record record2 = gRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)2, (Object)"data", (Object)"bbb"));
        Record record3 = gRecord.copy();
        record3.setField("id", (Object)3);
        record3.setField("data", null);
        StructLikeMap map = StructLikeMap.create((Types.StructType)STRUCT_TYPE);
        Assert.assertEquals((long)0L, (long)map.size());
        map.putAll(ImmutableMap.of((Object)record1, (Object)"1-aaa", (Object)record2, (Object)"2-bbb", (Object)record3, (Object)"3-null"));
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey(record1));
        Assert.assertTrue((boolean)map.containsKey(record2));
        Assert.assertTrue((boolean)map.containsKey(record3));
        Assert.assertTrue((boolean)map.containsValue("1-aaa"));
        Assert.assertTrue((boolean)map.containsValue("2-bbb"));
        Assert.assertTrue((boolean)map.containsValue("3-null"));
        Assert.assertEquals((Object)"1-aaa", map.get(record1));
        Assert.assertEquals((Object)"2-bbb", map.get(record2));
        Assert.assertEquals((Object)"3-null", map.get(record3));
        Set keySet = map.keySet();
        Assert.assertEquals((long)3L, (long)keySet.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)record1, (Object)record2, (Object)record3), keySet);
        Collection values = map.values();
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"1-aaa", (Object)"2-bbb", (Object)"3-null"), (Object)Sets.newHashSet(values));
        Set entrySet = map.entrySet();
        Assert.assertEquals((long)3L, (long)entrySet.size());
        HashSet structLikeSet = Sets.newHashSet();
        HashSet valueSet = Sets.newHashSet();
        for (Map.Entry entry : entrySet) {
            structLikeSet.add((StructLike)entry.getKey());
            valueSet.add((String)entry.getValue());
        }
        Assert.assertEquals((Object)ImmutableSet.of((Object)record1, (Object)record2, (Object)record3), (Object)structLikeSet);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"1-aaa", (Object)"2-bbb", (Object)"3-null"), (Object)valueSet);
    }

    @Test
    public void testRemove() {
        GenericRecord gRecord = GenericRecord.create((Types.StructType)STRUCT_TYPE);
        Record record = gRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)1, (Object)"data", (Object)"aaa"));
        StructLikeMap map = StructLikeMap.create((Types.StructType)STRUCT_TYPE);
        map.put(record, "1-aaa");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"1-aaa", map.get(record));
        Assert.assertEquals((Object)"1-aaa", map.remove(record));
        Assert.assertEquals((long)0L, (long)map.size());
        map.put(record, "1-aaa");
        Assert.assertEquals((Object)"1-aaa", map.get(record));
    }

    @Test
    public void testNullKeys() {
        StructLikeMap map = StructLikeMap.create((Types.StructType)STRUCT_TYPE);
        Assert.assertFalse((boolean)map.containsKey(null));
        map.put(null, "aaa");
        Assert.assertTrue((boolean)map.containsKey(null));
        Assert.assertEquals((Object)"aaa", map.get(null));
        String replacedValue = map.put(null, "bbb");
        Assert.assertEquals((Object)"aaa", (Object)replacedValue);
        String removedValue = (String)map.remove(null);
        Assert.assertEquals((Object)"bbb", (Object)removedValue);
    }

    @Test
    public void testKeysWithNulls() {
        GenericRecord recordTemplate = GenericRecord.create((Types.StructType)STRUCT_TYPE);
        Record record1 = recordTemplate.copy("id", (Object)1, "data", null);
        Record record2 = recordTemplate.copy("id", (Object)2, "data", null);
        StructLikeMap map = StructLikeMap.create((Types.StructType)STRUCT_TYPE);
        map.put(record1, "aaa");
        map.put(record2, "bbb");
        Assert.assertEquals((Object)"aaa", map.get(record1));
        Assert.assertEquals((Object)"bbb", map.get(record2));
        Record record3 = record1.copy();
        Assert.assertTrue((boolean)map.containsKey(record3));
        Assert.assertEquals((Object)"aaa", map.get(record3));
        Assert.assertEquals((Object)"aaa", map.remove(record3));
    }
}

