/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.File;
import java.io.IOException;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SortOrderUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestSortOrderUtil {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)10, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)12, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)13, (String)"category", (Type)Types.StringType.get())});
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private File tableDir = null;

    @Before
    public void setupTableDir() throws IOException {
        this.tableDir = this.temp.newFolder();
    }

    @After
    public void cleanupTables() {
        TestTables.clearTables();
    }

    @Test
    public void testEmptySpecsV1() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        SortOrder order = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).asc("id", NullOrder.NULLS_LAST)).build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, spec, order, 1);
        SortOrder actualOrder = SortOrderUtil.buildSortOrder((Schema)table.schema(), (PartitionSpec)spec, (SortOrder)table.sortOrder());
        Assert.assertEquals((String)"Order ID must be fresh", (long)1L, (long)actualOrder.orderId());
        Assert.assertEquals((String)"Order must have 1 field", (long)1L, (long)actualOrder.fields().size());
        Assert.assertEquals((String)"Field id must be fresh", (long)1L, (long)((SortField)actualOrder.fields().get(0)).sourceId());
        Assert.assertEquals((String)"Direction must match", (Object)SortDirection.ASC, (Object)((SortField)actualOrder.fields().get(0)).direction());
        Assert.assertEquals((String)"Null order must match", (Object)NullOrder.NULLS_LAST, (Object)((SortField)actualOrder.fields().get(0)).nullOrder());
    }

    @Test
    public void testEmptySpecsV2() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        SortOrder order = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).asc("id", NullOrder.NULLS_LAST)).build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, spec, order, 2);
        SortOrder actualOrder = SortOrderUtil.buildSortOrder((Schema)table.schema(), (PartitionSpec)spec, (SortOrder)table.sortOrder());
        Assert.assertEquals((String)"Order ID must be fresh", (long)1L, (long)actualOrder.orderId());
        Assert.assertEquals((String)"Order must have 1 field", (long)1L, (long)actualOrder.fields().size());
        Assert.assertEquals((String)"Field id must be fresh", (long)1L, (long)((SortField)actualOrder.fields().get(0)).sourceId());
        Assert.assertEquals((String)"Direction must match", (Object)SortDirection.ASC, (Object)((SortField)actualOrder.fields().get(0)).direction());
        Assert.assertEquals((String)"Null order must match", (Object)NullOrder.NULLS_LAST, (Object)((SortField)actualOrder.fields().get(0)).nullOrder());
    }

    @Test
    public void testSortOrderClusteringNoPartitionFields() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("ts").identity("category").build();
        SortOrder order = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).desc("id")).build();
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).asc((Term)Expressions.day((String)"ts"))).asc("category")).desc("id")).build();
        Assert.assertEquals((String)"Should add spec fields as prefix", (Object)expected, (Object)SortOrderUtil.buildSortOrder((Schema)SCHEMA, (PartitionSpec)spec, (SortOrder)order));
    }

    @Test
    public void testSortOrderClusteringAllPartitionFields() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("ts").identity("category").build();
        SortOrder order = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).asc((Term)Expressions.day((String)"ts"))).asc("category")).desc("id")).build();
        Assert.assertEquals((String)"Should leave the order unchanged", (Object)order, (Object)SortOrderUtil.buildSortOrder((Schema)SCHEMA, (PartitionSpec)spec, (SortOrder)order));
    }

    @Test
    public void testSortOrderClusteringAllPartitionFieldsReordered() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").day("ts").build();
        SortOrder order = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).asc((Term)Expressions.day((String)"ts"))).asc("category")).desc("id")).build();
        Assert.assertEquals((String)"Should leave the order unchanged", (Object)order, (Object)SortOrderUtil.buildSortOrder((Schema)SCHEMA, (PartitionSpec)spec, (SortOrder)order));
    }

    @Test
    public void testSortOrderClusteringSomePartitionFields() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").day("ts").build();
        SortOrder order = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).asc("category")).desc("id")).build();
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).asc((Term)Expressions.day((String)"ts"))).asc("category")).desc("id")).build();
        Assert.assertEquals((String)"Should add spec fields as prefix", (Object)expected, (Object)SortOrderUtil.buildSortOrder((Schema)SCHEMA, (PartitionSpec)spec, (SortOrder)order));
    }

    @Test
    public void testSortOrderClusteringSatisfiedPartitionLast() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").day("ts").build();
        SortOrder order = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).asc("category")).asc("ts")).desc("id")).build();
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).asc("category")).asc("ts")).desc("id")).build();
        Assert.assertEquals((String)"Should add spec fields as prefix", (Object)expected, (Object)SortOrderUtil.buildSortOrder((Schema)SCHEMA, (PartitionSpec)spec, (SortOrder)order));
    }

    @Test
    public void testSortOrderClusteringSatisfiedPartitionFirst() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("ts").identity("category").build();
        SortOrder order = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).asc("ts")).asc("category")).desc("id")).build();
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).asc("category")).asc("ts")).asc("category")).desc("id")).build();
        Assert.assertEquals((String)"Should add spec fields as prefix", (Object)expected, (Object)SortOrderUtil.buildSortOrder((Schema)SCHEMA, (PartitionSpec)spec, (SortOrder)order));
    }

    @Test
    public void testSortOrderClusteringSatisfiedPartitionFields() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("ts").identity("category").build();
        SortOrder order = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).asc("ts")).asc("category")).desc("id")).build();
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(1).asc("category")).asc("ts")).asc("category")).desc("id")).build();
        Assert.assertEquals((String)"Should add spec fields as prefix", (Object)expected, (Object)SortOrderUtil.buildSortOrder((Schema)SCHEMA, (PartitionSpec)spec, (SortOrder)order));
    }

    @Test
    public void testSortOrderClusteringWithRedundantPartitionFields() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("ts").identity("category").build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, spec, SortOrder.unsorted(), 2);
        table.updateSpec().addField((Term)Expressions.hour((String)"ts")).commit();
        PartitionSpec updatedSpec = table.spec();
        SortOrder order = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("category")).asc("ts")).desc("id")).build();
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("category")).asc("ts")).desc("id")).build();
        Assert.assertEquals((String)"Should add spec fields as prefix", (Object)expected, (Object)SortOrderUtil.buildSortOrder((Schema)table.schema(), (PartitionSpec)updatedSpec, (SortOrder)order));
    }

    @Test
    public void testSortOrderClusteringWithRedundantPartitionFieldsMissing() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("ts").identity("category").build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, spec, SortOrder.unsorted(), 1);
        table.updateSpec().removeField("ts_day").addField((Term)Expressions.hour((String)"ts")).commit();
        PartitionSpec updatedSpec = table.spec();
        SortOrder order = ((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).desc("id")).build();
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("category")).asc((Term)Expressions.hour((String)"ts"))).desc("id")).build();
        Assert.assertEquals((String)"Should add spec fields as prefix", (Object)expected, (Object)SortOrderUtil.buildSortOrder((Schema)table.schema(), (PartitionSpec)updatedSpec, (SortOrder)order));
    }
}

