/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.File;
import java.util.List;
import java.util.stream.StreamSupport;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestSnapshotUtil {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    public static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())});
    protected static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).build();
    protected File tableDir = null;
    protected File metadataDir = null;
    public TestTables.TestTable table = null;
    static final DataFile FILE_A = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
    private long snapshotAId;
    private long snapshotATimestamp;
    private long snapshotBId;
    private long snapshotCId;
    private long snapshotDId;

    @Before
    public void before() throws Exception {
        this.tableDir = this.temp.newFolder();
        this.tableDir.delete();
        this.metadataDir = new File(this.tableDir, "metadata");
        this.table = TestTables.create(this.tableDir, "test", SCHEMA, SPEC, 2);
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Snapshot snapshotA = this.table.currentSnapshot();
        this.snapshotAId = snapshotA.snapshotId();
        this.snapshotATimestamp = snapshotA.timestampMillis();
        TestHelpers.waitUntilAfter((long)this.snapshotATimestamp);
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.snapshotBId = this.table.currentSnapshot().snapshotId();
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.snapshotDId = this.table.currentSnapshot().snapshotId();
        String branchName = "b1";
        this.table.manageSnapshots().createBranch(branchName, this.snapshotAId).commit();
        ((AppendFiles)this.table.newFastAppend().appendFile(FILE_A).toBranch(branchName)).commit();
        this.snapshotCId = this.table.snapshot(branchName).snapshotId();
    }

    @After
    public void cleanupTables() {
        TestTables.clearTables();
    }

    @Test
    public void isParentAncestorOf() {
        Assert.assertTrue((boolean)SnapshotUtil.isParentAncestorOf((Table)this.table, (long)this.snapshotBId, (long)this.snapshotAId));
        Assert.assertFalse((boolean)SnapshotUtil.isParentAncestorOf((Table)this.table, (long)this.snapshotCId, (long)this.snapshotBId));
    }

    @Test
    public void isAncestorOf() {
        Assert.assertTrue((boolean)SnapshotUtil.isAncestorOf((Table)this.table, (long)this.snapshotBId, (long)this.snapshotAId));
        Assert.assertFalse((boolean)SnapshotUtil.isAncestorOf((Table)this.table, (long)this.snapshotCId, (long)this.snapshotBId));
        Assert.assertTrue((boolean)SnapshotUtil.isAncestorOf((Table)this.table, (long)this.snapshotBId));
        Assert.assertFalse((boolean)SnapshotUtil.isAncestorOf((Table)this.table, (long)this.snapshotCId));
    }

    @Test
    public void currentAncestors() {
        Iterable snapshots = SnapshotUtil.currentAncestors((Table)this.table);
        this.expectedSnapshots(new long[]{this.snapshotDId, this.snapshotBId, this.snapshotAId}, snapshots);
        List snapshotList = SnapshotUtil.currentAncestorIds((Table)this.table);
        Assert.assertArrayEquals((Object[])new Long[]{this.snapshotDId, this.snapshotBId, this.snapshotAId}, (Object[])snapshotList.toArray(new Long[0]));
    }

    @Test
    public void oldestAncestor() {
        Snapshot snapshot = SnapshotUtil.oldestAncestor((Table)this.table);
        Assert.assertEquals((long)this.snapshotAId, (long)snapshot.snapshotId());
        snapshot = SnapshotUtil.oldestAncestorOf((Table)this.table, (long)this.snapshotDId);
        Assert.assertEquals((long)this.snapshotAId, (long)snapshot.snapshotId());
        snapshot = SnapshotUtil.oldestAncestorAfter((Table)this.table, (long)(this.snapshotATimestamp + 1L));
        Assert.assertEquals((long)this.snapshotBId, (long)snapshot.snapshotId());
    }

    @Test
    public void snapshotsBetween() {
        List snapshotIdsBetween = SnapshotUtil.snapshotIdsBetween((Table)this.table, (long)this.snapshotAId, (long)this.snapshotDId);
        Assert.assertArrayEquals((Object[])new Long[]{this.snapshotDId, this.snapshotBId}, (Object[])snapshotIdsBetween.toArray(new Long[0]));
        Iterable ancestorsBetween = SnapshotUtil.ancestorsBetween((Table)this.table, (long)this.snapshotDId, (Long)this.snapshotBId);
        this.expectedSnapshots(new long[]{this.snapshotDId}, ancestorsBetween);
        ancestorsBetween = SnapshotUtil.ancestorsBetween((Table)this.table, (long)this.snapshotDId, (Long)this.snapshotCId);
        this.expectedSnapshots(new long[]{this.snapshotDId, this.snapshotBId, this.snapshotAId}, ancestorsBetween);
    }

    private void expectedSnapshots(long[] snapshotIdExpected, Iterable<Snapshot> snapshotsActual) {
        long[] actualSnapshots = StreamSupport.stream(snapshotsActual.spliterator(), false).mapToLong(Snapshot::snapshotId).toArray();
        Assert.assertArrayEquals((long[])snapshotIdExpected, (long[])actualSnapshots);
    }
}

